/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.touch;

import com.google.common.base.Preconditions;
import io.appium.java_client.touch.offset.AbstractOptionCombinedWithPosition;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public class LongPressOptions
extends AbstractOptionCombinedWithPosition<LongPressOptions> {
    protected Duration duration = null;

    public static LongPressOptions longPressOptions() {
        return new LongPressOptions();
    }

    public LongPressOptions withDuration(Duration duration) {
        Preconditions.checkNotNull(duration);
        Preconditions.checkArgument(duration.toMillis() >= 0L, "Duration value should be greater or equal to zero");
        this.duration = duration;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        Map<String, Object> result = super.build();
        Optional.ofNullable(this.duration).ifPresent(durationParam -> {
            Long l = result.put("duration", durationParam.toMillis());
        });
        return result;
    }
}

