/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.service.local.AppiumServerHasNotBeenStartedLocallyException;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.ListOutputStream;
import io.appium.java_client.service.local.Slf4jLogMessageContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class AppiumDriverLocalService
extends DriverService {
    private static final String URL_MASK = "http://%s:%d/wd/hub";
    private static final Logger LOG = LoggerFactory.getLogger(AppiumDriverLocalService.class);
    private static final Pattern LOG_MESSAGE_PATTERN = Pattern.compile("^(.*)\\R");
    private static final Pattern LOGGER_CONTEXT_PATTERN = Pattern.compile("^(\\[debug\\] )?\\[(.+?)\\]");
    private static final String APPIUM_SERVICE_SLF4J_LOGGER_PREFIX = "appium.service";
    private final File nodeJSExec;
    private final ImmutableList<String> nodeJSArgs;
    private final ImmutableMap<String, String> nodeJSEnvironment;
    private final long startupTimeout;
    private final TimeUnit timeUnit;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ListOutputStream stream = new ListOutputStream().add(System.out);
    private final URL url;
    private CommandLine process = null;

    AppiumDriverLocalService(String ipAddress, File nodeJSExec, int nodeJSPort, ImmutableList<String> nodeJSArgs, ImmutableMap<String, String> nodeJSEnvironment, long startupTimeout, TimeUnit timeUnit) throws IOException {
        super(nodeJSExec, nodeJSPort, nodeJSArgs, nodeJSEnvironment);
        this.nodeJSExec = nodeJSExec;
        this.nodeJSArgs = nodeJSArgs;
        this.nodeJSEnvironment = nodeJSEnvironment;
        this.startupTimeout = startupTimeout;
        this.timeUnit = timeUnit;
        this.url = new URL(String.format(URL_MASK, ipAddress, nodeJSPort));
    }

    public static AppiumDriverLocalService buildDefaultService() {
        return AppiumDriverLocalService.buildService(new AppiumServiceBuilder());
    }

    public static AppiumDriverLocalService buildService(AppiumServiceBuilder builder) {
        return (AppiumDriverLocalService)builder.build();
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isRunning() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return false;
            }
            if (!this.process.isRunning()) {
                return false;
            }
            this.ping(1500L, TimeUnit.MILLISECONDS);
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void ping(long time, TimeUnit timeUnit) throws UrlChecker.TimeoutException, MalformedURLException {
        URL status = new URL(String.valueOf(this.url.toString()) + "/status");
        new UrlChecker().waitUntilAvailable(time, timeUnit, status);
    }

    @Override
    public void start() throws AppiumServerHasNotBeenStartedLocallyException {
        this.lock.lock();
        try {
            if (this.isRunning()) {
                return;
            }
            try {
                this.process = new CommandLine(this.nodeJSExec.getCanonicalPath(), this.nodeJSArgs.toArray(new String[0]));
                this.process.setEnvironmentVariables(this.nodeJSEnvironment);
                this.process.copyOutputTo(this.stream);
                this.process.executeAsync();
                this.ping(this.startupTimeout, this.timeUnit);
            }
            catch (Throwable e) {
                String processStream;
                this.destroyProcess();
                String msgTxt = "The local appium server has not been started. The given Node.js executable: " + this.nodeJSExec.getAbsolutePath() + " Arguments: " + this.nodeJSArgs.toString() + " " + "\n";
                if (this.process != null && !StringUtils.isBlank(processStream = this.process.getStdOut())) {
                    msgTxt = String.valueOf(msgTxt) + "Process output: " + processStream + "\n";
                }
                throw new AppiumServerHasNotBeenStartedLocallyException(msgTxt, e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            if (this.process != null) {
                this.destroyProcess();
            }
            this.process = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void destroyProcess() {
        if (this.process.isRunning()) {
            this.process.destroy();
        }
    }

    @Nullable
    public String getStdOut() {
        if (this.process != null) {
            return this.process.getStdOut();
        }
        return null;
    }

    public void addOutPutStream(OutputStream outputStream) {
        Preconditions.checkNotNull(outputStream, "outputStream parameter is NULL!");
        this.stream.add(outputStream);
    }

    public void addOutPutStreams(List<OutputStream> outputStreams) {
        Preconditions.checkNotNull(outputStreams, "outputStreams parameter is NULL!");
        for (OutputStream stream : outputStreams) {
            this.addOutPutStream(stream);
        }
    }

    public boolean clearOutPutStreams() {
        return this.stream.clear();
    }

    public void enableDefaultSlf4jLoggingOfOutputData() {
        this.addSlf4jLogMessageConsumer((logMessage, ctx) -> {
            if (ctx.getLevel().equals((Object)Level.DEBUG)) {
                ctx.getLogger().debug((String)logMessage);
            } else {
                ctx.getLogger().info((String)logMessage);
            }
        });
    }

    public void addSlf4jLogMessageConsumer(BiConsumer<String, Slf4jLogMessageContext> slf4jLogMessageConsumer) {
        Preconditions.checkNotNull(slf4jLogMessageConsumer, "slf4jLogMessageConsumer parameter is NULL!");
        this.addLogMessageConsumer(logMessage -> slf4jLogMessageConsumer.accept((String)logMessage, AppiumDriverLocalService.parseSlf4jContextFromLogMessage(logMessage)));
    }

    @VisibleForTesting
    static Slf4jLogMessageContext parseSlf4jContextFromLogMessage(String logMessage) {
        Matcher m3 = LOGGER_CONTEXT_PATTERN.matcher(logMessage);
        String loggerName = APPIUM_SERVICE_SLF4J_LOGGER_PREFIX;
        Level level = Level.INFO;
        if (m3.find()) {
            loggerName = String.valueOf(loggerName) + "." + m3.group(2).toLowerCase().replaceAll("\\s+", "");
            if (m3.group(1) != null) {
                level = Level.DEBUG;
            }
        }
        return new Slf4jLogMessageContext(loggerName, level);
    }

    public void addLogMessageConsumer(final Consumer<String> consumer) {
        Preconditions.checkNotNull(consumer, "consumer parameter is NULL!");
        this.addOutPutStream(new OutputStream(){
            StringBuilder lineBuilder = new StringBuilder();

            @Override
            public void write(int chr) {
                try {
                    this.lineBuilder.append((char)chr);
                    Matcher matcher = LOG_MESSAGE_PATTERN.matcher(this.lineBuilder.toString());
                    if (matcher.matches()) {
                        consumer.accept(matcher.group(1));
                        this.lineBuilder = new StringBuilder();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Log message consumer crashed!", e);
                }
            }
        });
    }
}

