/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.screenrecording;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public class ScreenRecordingUploadOptions {
    private String remotePath;
    private String user;
    private String pass;
    private String method;

    public static ScreenRecordingUploadOptions uploadOptions() {
        return new ScreenRecordingUploadOptions();
    }

    public ScreenRecordingUploadOptions withRemotePath(String remotePath) {
        this.remotePath = Preconditions.checkNotNull(remotePath);
        return this;
    }

    public ScreenRecordingUploadOptions withAuthCredentials(String user, String pass) {
        this.user = Preconditions.checkNotNull(user);
        this.pass = Preconditions.checkNotNull(pass);
        return this;
    }

    public ScreenRecordingUploadOptions withHttpMethod(RequestMethod method) {
        this.method = Preconditions.checkNotNull(method).name();
        return this;
    }

    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Optional.ofNullable(this.remotePath).map(x -> builder.put("remotePath", x));
        Optional.ofNullable(this.user).map(x -> builder.put("user", x));
        Optional.ofNullable(this.pass).map(x -> builder.put("pass", x));
        Optional.ofNullable(this.method).map(x -> builder.put("method", x));
        return builder.build();
    }

    public static enum RequestMethod {
        POST,
        PUT;

    }
}

