/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.FileBackedOutputStream;
import io.appium.java_client.remote.AndroidMobileCapabilityType;
import io.appium.java_client.remote.IOSMobileCapabilityType;
import io.appium.java_client.remote.MobileCapabilityType;
import io.appium.java_client.remote.YouiEngineCapabilityType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.session.CapabilitiesFilter;
import org.openqa.selenium.remote.session.CapabilityTransform;
import org.openqa.selenium.remote.session.ChromeFilter;
import org.openqa.selenium.remote.session.EdgeFilter;
import org.openqa.selenium.remote.session.FirefoxFilter;
import org.openqa.selenium.remote.session.InternetExplorerFilter;
import org.openqa.selenium.remote.session.OperaFilter;
import org.openqa.selenium.remote.session.ProxyTransform;
import org.openqa.selenium.remote.session.SafariFilter;
import org.openqa.selenium.remote.session.StripAnyPlatform;
import org.openqa.selenium.remote.session.W3CPlatformNameNormaliser;

public class NewAppiumSessionPayload
implements Closeable {
    private static final List<String> APPIUM_CAPABILITIES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(NewAppiumSessionPayload.getAppiumCapabilities(MobileCapabilityType.class))).addAll(NewAppiumSessionPayload.getAppiumCapabilities(AndroidMobileCapabilityType.class))).addAll(NewAppiumSessionPayload.getAppiumCapabilities(IOSMobileCapabilityType.class))).addAll(NewAppiumSessionPayload.getAppiumCapabilities(YouiEngineCapabilityType.class))).build();
    private static final String APPIUM_PREFIX = "appium:";
    private static final String DESIRED_CAPABILITIES = "desiredCapabilities";
    private static final String CAPABILITIES = "capabilities";
    private static final String REQUIRED_CAPABILITIES = "requiredCapabilities";
    private static final String FIRST_MATCH = "firstMatch";
    private static final String ALWAYS_MATCH = "alwaysMatch";
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();
    private final Set<CapabilitiesFilter> adapters;
    private final Set<CapabilityTransform> transforms;
    private final boolean forceMobileJSONWP;
    private final Json json = new Json();
    private final FileBackedOutputStream backingStore;

    private static List<String> getAppiumCapabilities(Class<?> capabilityList) {
        return Arrays.stream(capabilityList.getDeclaredFields()).map(field -> {
            field.setAccessible(true);
            try {
                return field.get(capabilityList).toString();
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }).filter(s2 -> !"forceMjsonwp".equals(s2)).collect(Collectors.toList());
    }

    public static NewAppiumSessionPayload create(Capabilities caps) throws IOException {
        boolean forceMobileJSONWP = Optional.ofNullable(caps.getCapability("forceMjsonwp")).map(o -> Boolean.class.isAssignableFrom(o.getClass()) && (Boolean)Boolean.class.cast(o) != false).orElse(false);
        HashMap<String, Object> capabilityMap = new HashMap<String, Object>(caps.asMap());
        capabilityMap.remove("forceMjsonwp");
        ImmutableMap<String, HashMap<String, Object>> source = ImmutableMap.of(DESIRED_CAPABILITIES, capabilityMap);
        String json = new Json().toJson(source);
        return new NewAppiumSessionPayload(new StringReader(json), forceMobileJSONWP);
    }

    private NewAppiumSessionPayload(Reader source, boolean forceMobileJSONWP) throws IOException {
        this.forceMobileJSONWP = forceMobileJSONWP;
        int threshold = (int)Math.min(Integer.MAX_VALUE, Math.min(Runtime.getRuntime().freeMemory() / 5L, Runtime.getRuntime().maxMemory() / 10L));
        this.backingStore = new FileBackedOutputStream(threshold);
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.backingStore, StandardCharsets.UTF_8);){
            CharStreams.copy(source, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ImmutableSet.Builder adapters = ImmutableSet.builder();
        ServiceLoader.load(CapabilitiesFilter.class).forEach(adapters::add);
        ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)adapters.add(new ChromeFilter())).add(new EdgeFilter())).add(new FirefoxFilter())).add(new InternetExplorerFilter())).add(new OperaFilter())).add(new SafariFilter());
        this.adapters = adapters.build();
        ImmutableSet.Builder transforms = ImmutableSet.builder();
        ServiceLoader.load(CapabilityTransform.class).forEach(transforms::add);
        ((ImmutableSet.Builder)((ImmutableSet.Builder)transforms.add(new ProxyTransform())).add(new StripAnyPlatform())).add(new W3CPlatformNameNormaliser());
        this.transforms = transforms.build();
        ImmutableSet.Builder dialects = ImmutableSet.builder();
        if (this.getOss() != null) {
            dialects.add((Object)Dialect.OSS);
        }
        if (this.getAlwaysMatch() != null || this.getFirstMatch() != null) {
            dialects.add((Object)Dialect.W3C);
        }
        this.validate();
    }

    private void validate() throws IOException {
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        if (alwaysMatch == null) {
            alwaysMatch = ImmutableMap.of();
        }
        Map<String, Object> always = alwaysMatch;
        Collection<Map<String, Object>> firsts = this.getFirstMatch();
        if (firsts == null) {
            firsts = ImmutableList.of(ImmutableMap.of());
        }
        if (firsts.isEmpty()) {
            throw new IllegalArgumentException("First match w3c capabilities is zero length");
        }
        firsts.stream().peek(map2 -> {
            Sets.SetView overlap = Sets.intersection(always.keySet(), map2.keySet());
            if (!overlap.isEmpty()) {
                throw new IllegalArgumentException("Overlapping keys between w3c always and first match capabilities: " + overlap);
            }
        }).map(first -> {
            HashMap toReturn = new HashMap();
            toReturn.putAll(always);
            toReturn.putAll(first);
            return toReturn;
        }).peek(map -> {
            ImmutableSortedSet nullKeys = map.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet(Ordering.natural()));
            if (!nullKeys.isEmpty()) {
                throw new IllegalArgumentException("Null values found in w3c capabilities. Keys are: " + nullKeys);
            }
        }).peek(map -> {
            ImmutableSortedSet illegalKeys = map.entrySet().stream().filter(entry -> !ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).map(Map.Entry::getKey).collect(ImmutableSortedSet.toImmutableSortedSet(Ordering.natural()));
            if (!illegalKeys.isEmpty()) {
                throw new IllegalArgumentException("Illegal key values seen in w3c capabilities: " + illegalKeys);
            }
        });
    }

    public void writeTo(Appendable appendable) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JsonOutput json = new Json().newOutput(appendable);){
            json.beginObject();
            Map<String, Object> first = this.getOss();
            if (first == null) {
                first = this.stream().findFirst().orElse(new ImmutableCapabilities()).asMap();
            }
            json.name(DESIRED_CAPABILITIES);
            json.write(first);
            if (!this.forceMobileJSONWP) {
                json.name(CAPABILITIES);
                json.beginObject();
                json.name(FIRST_MATCH);
                json.beginArray();
                this.getW3C().forEach(json::write);
                json.endArray();
                json.endObject();
            }
            this.writeMetaData(json);
            json.endObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeMetaData(JsonOutput out) throws IOException {
        CharSource charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedReader reader = charSource.openBufferedStream();
            try {
                try (JsonInput input = this.json.newInput(reader);){
                    input.beginObject();
                    while (input.hasNext()) {
                        String name;
                        switch (name = input.nextName()) {
                            case "desiredCapabilities": 
                            case "capabilities": 
                            case "requiredCapabilities": {
                                input.skipValue();
                                break;
                            }
                            default: {
                                out.name(name);
                                out.write(input.read((Type)((Object)Object.class)));
                            }
                        }
                    }
                }
                if (reader == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                ((Reader)reader).close();
                throw throwable;
            }
            ((Reader)reader).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public Stream<Capabilities> stream() throws IOException {
        Stream<Map<String, Object>> oss = Stream.of(this.getOss());
        Stream<Map<String, Object>> w3c = this.getW3C();
        return Stream.concat(oss, w3c).filter(Objects::nonNull).map(this::applyTransforms).filter(Objects::nonNull).distinct().map(ImmutableCapabilities::new);
    }

    @Override
    public void close() throws IOException {
        this.backingStore.reset();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private Map<String, Object> getOss() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Stream<Map<String, Object>> getW3C() throws IOException {
        Stream<Map> fromW3c;
        Stream<Map> fromOss;
        Map<String, Object> oss = this.convertOssToW3C(this.getOss());
        if (oss != null) {
            HashSet usedKeys = new HashSet();
            ImmutableList firsts = this.adapters.stream().map(adapter -> adapter.apply(oss)).filter(Objects::nonNull).filter(map -> !map.isEmpty()).map(map -> map.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).peek(map -> {
                boolean bl = usedKeys.addAll(map.keySet());
            }).collect(ImmutableList.toImmutableList());
            if (firsts.isEmpty()) {
                firsts = ImmutableList.of(ImmutableMap.of());
            }
            Map always = oss.entrySet().stream().filter(entry -> !usedKeys.contains(entry.getKey())).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            fromOss = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build()).map(this::applyTransforms).map(map -> map.entrySet().stream().filter(entry -> !this.forceMobileJSONWP || ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).map(stringObjectEntry -> new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    String key = (String)stringObjectEntry.getKey();
                    if (APPIUM_CAPABILITIES.contains(key) && !NewAppiumSessionPayload.this.forceMobileJSONWP) {
                        return NewAppiumSessionPayload.APPIUM_PREFIX + key;
                    }
                    return key;
                }

                @Override
                public Object getValue() {
                    return stringObjectEntry.getValue();
                }

                @Override
                public Object setValue(Object value) {
                    return stringObjectEntry.setValue(value);
                }
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))).map(map -> map);
        } else {
            fromOss = Stream.of(new Map[0]);
        }
        Map<String, Object> alwaysMatch = this.getAlwaysMatch();
        Collection<Map<String, Object>> firsts = this.getFirstMatch();
        if (alwaysMatch == null && firsts == null) {
            fromW3c = Stream.of(new Map[0]);
        } else {
            if (alwaysMatch == null) {
                alwaysMatch = ImmutableMap.of();
            }
            Map<String, Object> always = alwaysMatch;
            if (firsts == null) {
                firsts = ImmutableList.of(ImmutableMap.of());
            }
            fromW3c = firsts.stream().map(first -> ImmutableMap.builder().putAll(always).putAll(first).build());
        }
        return Stream.concat(fromOss, fromW3c).distinct();
    }

    @Nullable
    private Map<String, Object> convertOssToW3C(Map<String, Object> capabilities) {
        if (capabilities == null) {
            return null;
        }
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>(capabilities);
        if (capabilities.containsKey("platform") && !capabilities.containsKey("platformName")) {
            toReturn.put("platformName", String.valueOf(capabilities.get("platform")));
        }
        return toReturn;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Map<String, Object> getAlwaysMatch() throws IOException {
        charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        var2_2 = null;
        var3_4 = null;
        try {
            reader = charSource.openBufferedStream();
            try {
                input = this.json.newInput(reader);
                try {
                    input.beginObject();
                    while (input.hasNext()) {
                        block17: {
                            name = input.nextName();
                            if (!"capabilities".equals(name)) break block17;
                            input.beginObject();
                            if (true) ** GOTO lbl27
                        }
                        input.skipValue();
                        continue;
                        do {
                            if ("alwaysMatch".equals(name = input.nextName())) {
                                v0 = (Map)input.read(Json.MAP_TYPE);
                                if (input != null) {
                                    input.close();
                                }
                                if (reader == null) return v0;
                                reader.close();
                                return v0;
                            }
                            input.skipValue();
lbl27:
                            // 2 sources

                        } while (input.hasNext());
                        input.endObject();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Throwable var2_3) {
                    if (input == null) throw var2_3;
                    input.close();
                    throw var2_3;
                }
                if (reader == null) return null;
            }
            catch (Throwable var3_5) {
                if (var2_2 == null) {
                    var2_2 = var3_5;
                } else if (var2_2 != var3_5) {
                    var2_2.addSuppressed(var3_5);
                }
                if (reader == null) throw var2_2;
                reader.close();
                throw var2_2;
            }
            reader.close();
            return null;
        }
        catch (Throwable var3_6) {
            if (var2_2 == null) {
                var2_2 = var3_6;
                throw var2_2;
            }
            if (var2_2 == var3_6) throw var2_2;
            var2_2.addSuppressed(var3_6);
            throw var2_2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Collection<Map<String, Object>> getFirstMatch() throws IOException {
        charSource = this.backingStore.asByteSource().asCharSource(StandardCharsets.UTF_8);
        var2_2 = null;
        var3_4 = null;
        try {
            reader = charSource.openBufferedStream();
            try {
                input = this.json.newInput(reader);
                try {
                    input.beginObject();
                    while (input.hasNext()) {
                        block17: {
                            name = input.nextName();
                            if (!"capabilities".equals(name)) break block17;
                            input.beginObject();
                            if (true) ** GOTO lbl27
                        }
                        input.skipValue();
                        continue;
                        do {
                            if ("firstMatch".equals(name = input.nextName())) {
                                v0 = (Collection)input.read(Json.LIST_OF_MAPS_TYPE);
                                if (input != null) {
                                    input.close();
                                }
                                if (reader == null) return v0;
                                reader.close();
                                return v0;
                            }
                            input.skipValue();
lbl27:
                            // 2 sources

                        } while (input.hasNext());
                        input.endObject();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Throwable var2_3) {
                    if (input == null) throw var2_3;
                    input.close();
                    throw var2_3;
                }
                if (reader == null) return null;
            }
            catch (Throwable var3_5) {
                if (var2_2 == null) {
                    var2_2 = var3_5;
                } else if (var2_2 != var3_5) {
                    var2_2.addSuppressed(var3_5);
                }
                if (reader == null) throw var2_2;
                reader.close();
                throw var2_2;
            }
            reader.close();
            return null;
        }
        catch (Throwable var3_6) {
            if (var2_2 == null) {
                var2_2 = var3_6;
                throw var2_2;
            }
            if (var2_2 == var3_6) throw var2_2;
            var2_2.addSuppressed(var3_6);
            throw var2_2;
        }
    }

    private Map<String, Object> applyTransforms(Map<String, Object> caps) {
        LinkedList<Map.Entry<String, Object>> toExamine = new LinkedList<Map.Entry<String, Object>>(caps.entrySet());
        HashSet<String> seenKeys = new HashSet<String>();
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        block0: while (!toExamine.isEmpty()) {
            Map.Entry<String, Object> entry = (Map.Entry<String, Object>)toExamine.remove();
            seenKeys.add((String)entry.getKey());
            if (entry.getValue() == null) continue;
            for (CapabilityTransform transform : this.transforms) {
                Collection<Map.Entry<String, Object>> result = transform.apply(entry);
                if (result == null) {
                    toReturn.remove(entry.getKey());
                    continue block0;
                }
                for (Map.Entry<String, Object> newEntry : result) {
                    if (!seenKeys.contains(newEntry.getKey())) {
                        toExamine.add(newEntry);
                        continue;
                    }
                    if (newEntry.getKey().equals(entry.getKey())) {
                        entry = newEntry;
                    }
                    toReturn.put(newEntry.getKey(), newEntry.getValue());
                }
            }
        }
        return toReturn;
    }
}

