/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.interactions.KeyInput;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;

public class AppiumW3CHttpCommandCodec
extends W3CHttpCommandCodec {
    public AppiumW3CHttpCommandCodec() {
        this.defineCommand("getElementAttribute", AppiumW3CHttpCommandCodec.get("/session/:sessionId/element/:id/attribute/:name"));
        this.defineCommand("isElementDisplayed", AppiumW3CHttpCommandCodec.get("/session/:sessionId/element/:id/displayed"));
        this.defineCommand("getPageSource", AppiumW3CHttpCommandCodec.get("/session/:sessionId/source"));
        this.defineCommand("sendKeysToActiveElement", AppiumW3CHttpCommandCodec.post("/session/:sessionId/actions"));
    }

    @Override
    public void alias(String commandName, String isAnAliasFor) {
        switch (commandName) {
            case "submitElement": 
            case "getElementLocationOnceScrolledIntoView": 
            case "getElementSize": 
            case "getPageSource": 
            case "getElementLocation": 
            case "getElementAttribute": 
            case "isElementDisplayed": {
                return;
            }
        }
        super.alias(commandName, isAnAliasFor);
    }

    @Override
    protected Map<String, ?> amendParameters(String name, Map<String, ?> parameters) {
        switch (name) {
            case "sendKeysToActiveElement": {
                Object rawValue = parameters.get("value");
                Stream<Object> source = rawValue instanceof Collection ? ((Collection)rawValue).stream() : Stream.of((CharSequence[])rawValue);
                String text = source.flatMap(Stream::of).collect(Collectors.joining());
                KeyInput keyboard = new KeyInput("keyboard");
                Sequence sequence = new Sequence(keyboard, 0);
                int i = 0;
                while (i < text.length()) {
                    sequence.addAction(keyboard.createKeyDown(text.charAt(i))).addAction(keyboard.createKeyUp(text.charAt(i)));
                    ++i;
                }
                return ImmutableMap.builder().put("actions", ImmutableList.of(sequence.toJson())).build();
            }
            case "sendKeysToElement": 
            case "setTimeout": {
                return super.amendParameters(name, parameters);
            }
        }
        return parameters;
    }
}

