/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import io.appium.java_client.internal.Config;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import io.appium.java_client.remote.NewAppiumSessionPayload;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
extends HttpCommandExecutor {
    private final Optional<DriverService> serviceOptional;

    private AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        super(additionalCommands, Optional.ofNullable(service).map(DriverService::getUrl).orElse(addressOfRemoteServer), httpClientFactory);
        this.serviceOptional = Optional.ofNullable(service);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, Preconditions.checkNotNull(service), null, httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, null, Preconditions.checkNotNull(addressOfRemoteServer), httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, HttpClient.Factory.createDefault());
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service) {
        this(additionalCommands, service, HttpClient.Factory.createDefault());
    }

    protected <B> B getPrivateFieldValue(String fieldName, Class<B> fieldType) {
        Class<?> superclass = this.getClass().getSuperclass();
        ReflectiveOperationException recentException = null;
        while (superclass != Object.class) {
            try {
                Field f = superclass.getDeclaredField(fieldName);
                f.setAccessible(true);
                return fieldType.cast(f.get(this));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                recentException = e;
                superclass = superclass.getSuperclass();
            }
        }
        throw new WebDriverException(recentException);
    }

    protected void setPrivateFieldValue(String fieldName, Object newValue) {
        Class<?> superclass = this.getClass().getSuperclass();
        ReflectiveOperationException recentException = null;
        while (superclass != Object.class) {
            try {
                Field f = superclass.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(this, newValue);
                return;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                recentException = e;
                superclass = superclass.getSuperclass();
            }
        }
        throw new WebDriverException(recentException);
    }

    protected Map<String, CommandInfo> getAdditionalCommands() {
        return this.getPrivateFieldValue("additionalCommands", Map.class);
    }

    protected CommandCodec<HttpRequest> getCommandCodec() {
        return this.getPrivateFieldValue("commandCodec", CommandCodec.class);
    }

    protected void setCommandCodec(CommandCodec<HttpRequest> newCodec) {
        this.setPrivateFieldValue("commandCodec", newCodec);
    }

    protected void setResponseCodec(ResponseCodec<HttpResponse> codec) {
        this.setPrivateFieldValue("responseCodec", codec);
    }

    protected HttpClient getClient() {
        return this.getPrivateFieldValue("client", HttpClient.class);
    }

    private Response createSession(Command command) throws IOException {
        if (this.getCommandCodec() != null) {
            throw new SessionNotCreatedException("Session already exists");
        }
        ProtocolHandshake handshake = new ProtocolHandshake(){

            /*
             * Loose catch block
             */
            @Override
            public ProtocolHandshake.Result createSession(HttpClient client, Command command) throws IOException {
                Capabilities desiredCapabilities = (Capabilities)command.getParameters().get("desiredCapabilities");
                Capabilities desired = desiredCapabilities == null ? new ImmutableCapabilities() : desiredCapabilities;
                int threshold = (int)Math.min(Runtime.getRuntime().freeMemory() / 10L, Integer.MAX_VALUE);
                FileBackedOutputStream os = new FileBackedOutputStream(threshold);
                try {
                    ProtocolHandshake.Result result;
                    BufferedInputStream contentStream;
                    InputStream rawIn;
                    Throwable throwable;
                    block27: {
                        block26: {
                            CountingOutputStream counter = new CountingOutputStream(os);
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counter, StandardCharsets.UTF_8);
                            NewAppiumSessionPayload payload = NewAppiumSessionPayload.create(desired);
                            payload.writeTo(writer);
                            throwable = null;
                            Object var11_14 = null;
                            rawIn = os.asByteSource().openBufferedStream();
                            contentStream = new BufferedInputStream(rawIn);
                            Method createSessionMethod = this.getClass().getSuperclass().getDeclaredMethod("createSession", HttpClient.class, InputStream.class, Long.TYPE);
                            createSessionMethod.setAccessible(true);
                            Optional result2 = (Optional)createSessionMethod.invoke((Object)this, client, contentStream, counter.getCount());
                            result = result2.map(result1 -> {
                                ProtocolHandshake.Result toReturn = (ProtocolHandshake.Result)result2.get();
                                Logger.getLogger(ProtocolHandshake.class.getName()).info(String.format("Detected dialect: %s", new Object[]{toReturn.getDialect()}));
                                return toReturn;
                            }).orElseThrow(() -> new SessionNotCreatedException(String.format("Unable to create a new remote session. Desired capabilities = %s", desired)));
                            if (contentStream == null) break block26;
                            contentStream.close();
                        }
                        if (rawIn == null) break block27;
                        rawIn.close();
                    }
                    return result;
                    {
                        catch (Throwable throwable2) {
                            try {
                                try {
                                    try {
                                        if (contentStream != null) {
                                            contentStream.close();
                                        }
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        if (rawIn != null) {
                                            rawIn.close();
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IllegalAccessException | NoSuchMethodException e) {
                                throw new SessionNotCreatedException(String.format("Unable to create a new remote session. Make sure your project dependencies config does not override Selenium API version %s used by java-client library.", Config.main().getValue("selenium.version", String.class)), e);
                            }
                            catch (InvocationTargetException e) {
                                String message = "Unable to create a new remote session.";
                                if (e.getCause() != null) {
                                    if (e.getCause() instanceof WebDriverException) {
                                        message = String.valueOf(message) + " Please check the server log for more details.";
                                    }
                                    message = String.valueOf(message) + String.format(" Original error: %s", e.getCause().getMessage());
                                }
                                throw new SessionNotCreatedException(message, e);
                            }
                        }
                    }
                }
                finally {
                    os.reset();
                }
            }
        };
        ProtocolHandshake.Result result = handshake.createSession(this.getClient(), command);
        Dialect dialect = result.getDialect();
        this.setCommandCodec(dialect.getCommandCodec());
        this.getAdditionalCommands().forEach(this::defineCommand);
        this.setResponseCodec(dialect.getResponseCodec());
        return result.createResponse();
    }

    @Override
    public Response execute(Command command) throws WebDriverException {
        Response response;
        if ("newSession".equals(command.getName())) {
            this.serviceOptional.ifPresent(driverService -> {
                try {
                    driverService.start();
                }
                catch (IOException e) {
                    throw new WebDriverException(e.getMessage(), e);
                }
            });
        }
        try {
            try {
                response = "newSession".equals(command.getName()) ? this.createSession(command) : super.execute(command);
            }
            catch (Throwable t) {
                Throwable rootCause = Throwables.getRootCause(t);
                if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused")) {
                    throw this.serviceOptional.map(service -> {
                        if (service.isRunning()) {
                            return new WebDriverException("The session is closed!", rootCause);
                        }
                        return new WebDriverException("The appium server has accidentally died!", rootCause);
                    }).orElseGet(() -> new WebDriverException(rootCause.getMessage(), rootCause));
                }
                Throwables.throwIfUnchecked(t);
                throw new WebDriverException(t);
            }
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.serviceOptional.ifPresent(DriverService::stop);
            }
        }
        if ("newSession".equals(command.getName()) && this.getCommandCodec() instanceof W3CHttpCommandCodec) {
            this.setCommandCodec(new AppiumW3CHttpCommandCodec());
            this.getAdditionalCommands().forEach(this::defineCommand);
        }
        return response;
    }
}

