/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public class IOSStartScreenRecordingOptions
extends BaseStartScreenRecordingOptions<IOSStartScreenRecordingOptions> {
    private String videoType;
    private String videoQuality;
    private String videoScale;
    private Integer fps;

    public static IOSStartScreenRecordingOptions startScreenRecordingOptions() {
        return new IOSStartScreenRecordingOptions();
    }

    public IOSStartScreenRecordingOptions withVideoType(String videoType) {
        this.videoType = Preconditions.checkNotNull(videoType);
        return this;
    }

    public IOSStartScreenRecordingOptions withVideoQuality(VideoQuality videoQuality) {
        this.videoQuality = Preconditions.checkNotNull(videoQuality).name().toLowerCase();
        return this;
    }

    public IOSStartScreenRecordingOptions withFps(int fps) {
        this.fps = fps;
        return this;
    }

    public IOSStartScreenRecordingOptions withVideoScale(String videoScale) {
        this.videoScale = Preconditions.checkNotNull(videoScale);
        return this;
    }

    @Override
    public IOSStartScreenRecordingOptions withTimeLimit(Duration timeLimit) {
        return (IOSStartScreenRecordingOptions)super.withTimeLimit(timeLimit);
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        builder.putAll(super.build());
        Optional.ofNullable(this.videoType).map(x -> builder.put("videoType", x));
        Optional.ofNullable(this.videoQuality).map(x -> builder.put("videoQuality", x));
        Optional.ofNullable(this.videoScale).map(x -> builder.put("videoScale", x));
        Optional.ofNullable(this.fps).map(x -> builder.put("videoFps", x));
        return builder.build();
    }

    public static enum VideoQuality {
        LOW,
        MEDIUM,
        HIGH,
        PHOTO;

    }
}

