/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.base.Preconditions;
import io.appium.java_client.clipboard.ClipboardContentType;
import io.appium.java_client.clipboard.HasClipboard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.imageio.ImageIO;

public interface HasIOSClipboard
extends HasClipboard {
    default public void setClipboardImage(BufferedImage img) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)Preconditions.checkNotNull(img), "png", os);
            this.setClipboard(ClipboardContentType.IMAGE, Base64.getMimeEncoder().encode(os.toByteArray()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public BufferedImage getClipboardImage() throws IOException {
        byte[] base64decodedBytes = Base64.getMimeDecoder().decode(this.getClipboard(ClipboardContentType.IMAGE));
        return ImageIO.read(new ByteArrayInputStream(base64decodedBytes));
    }

    default public void setClipboardUrl(URL url) {
        this.setClipboard(ClipboardContentType.URL, Base64.getMimeEncoder().encode(Preconditions.checkNotNull(url).toString().getBytes(StandardCharsets.UTF_8)));
    }

    default public URL getClipboardUrl() throws MalformedURLException {
        byte[] base64decodedBytes = Base64.getMimeDecoder().decode(this.getClipboard(ClipboardContentType.URL));
        return new URL(new String(base64decodedBytes, StandardCharsets.UTF_8));
    }
}

