/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal;

import io.appium.java_client.HasSessionDetails;
import io.appium.java_client.internal.ElementMap;
import java.lang.reflect.Constructor;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public class JsonToMobileElementConverter
extends JsonToWebElementConverter {
    protected final RemoteWebDriver driver;
    private final String platform;
    private final String automation;

    public JsonToMobileElementConverter(RemoteWebDriver driver, HasSessionDetails hasSessionDetails) {
        super(driver);
        this.driver = driver;
        this.platform = hasSessionDetails.getPlatformName();
        this.automation = hasSessionDetails.getAutomationName();
    }

    @Override
    public Object apply(Object result) {
        Object toBeReturned = result;
        if (toBeReturned instanceof RemoteWebElement) {
            toBeReturned = this.newRemoteWebElement();
            ((RemoteWebElement)toBeReturned).setId(((RemoteWebElement)result).getId());
        }
        return super.apply(toBeReturned);
    }

    @Override
    protected RemoteWebElement newRemoteWebElement() {
        Class<? extends RemoteWebElement> target = ElementMap.getElementClass(this.platform, this.automation);
        try {
            Constructor<? extends RemoteWebElement> constructor = target.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            RemoteWebElement result = constructor.newInstance(new Object[0]);
            result.setParent(this.driver);
            result.setFileDetector(this.driver.getFileDetector());
            return result;
        }
        catch (Exception e) {
            throw new WebDriverException(e);
        }
    }
}

