/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.imagecomparison;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.imagecomparison.BaseComparisonOptions;
import io.appium.java_client.imagecomparison.FeatureDetector;
import io.appium.java_client.imagecomparison.MatchingFunction;
import java.util.Map;
import java.util.Optional;

public class FeaturesMatchingOptions
extends BaseComparisonOptions<FeaturesMatchingOptions> {
    private String detectorName;
    private String matchFunc;
    private Integer goodMatchesFactor;

    public FeaturesMatchingOptions withDetectorName(FeatureDetector name) {
        this.detectorName = name.name();
        return this;
    }

    public FeaturesMatchingOptions withMatchFunc(MatchingFunction name) {
        this.matchFunc = name.toString();
        return this;
    }

    public FeaturesMatchingOptions withGoodMatchesFactor(int factor) {
        Preconditions.checkArgument(factor > 1);
        this.goodMatchesFactor = factor;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        builder.putAll(super.build());
        Optional.ofNullable(this.detectorName).map(x -> builder.put("detectorName", x));
        Optional.ofNullable(this.matchFunc).map(x -> builder.put("matchFunc", x));
        Optional.ofNullable(this.goodMatchesFactor).map(x -> builder.put("goodMatchesFactor", x));
        return builder.build();
    }
}

