/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.events;

import com.google.common.collect.ImmutableList;
import io.appium.java_client.events.DefaultListener;
import io.appium.java_client.events.api.Listener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.springframework.context.support.AbstractApplicationContext;

@Aspect
class DefaultAspect {
    private static final List<Class<?>> listenable = ImmutableList.of(WebDriver.class, WebElement.class, WebDriver.Navigation.class, WebDriver.TargetLocator.class, ContextAware.class, Alert.class, WebDriver.Options.class, WebDriver.Window.class);
    private static final String EXECUTION_NAVIGATION_TO = "execution(* org.openqa.selenium.WebDriver.Navigation.get(..))  || execution(* org.openqa.selenium.WebDriver.Navigation.to(..)) || execution(* org.openqa.selenium.WebDriver.get(..))";
    private static final String EXECUTION_NAVIGATION_BACK = "execution(* org.openqa.selenium.WebDriver.Navigation.back(..))";
    private static final String EXECUTION_NAVIGATION_FORWARD = "execution(* org.openqa.selenium.WebDriver.Navigation.forward(..))";
    private static final String EXECUTION_NAVIGATION_REFRESH = "execution(* org.openqa.selenium.WebDriver.Navigation.refresh(..))";
    private static final String EXECUTION_SEARCH = "execution(* org.openqa.selenium.SearchContext.findElement(..)) || execution(* org.openqa.selenium.SearchContext.findElements(..))";
    private static final String EXECUTION_CLICK = "execution(* org.openqa.selenium.WebElement.click(..))";
    private static final String EXECUTION_CHANGE_VALUE = "execution(* org.openqa.selenium.WebElement.sendKeys(..)) || execution(* org.openqa.selenium.WebElement.clear(..))  || execution(* io.appium.java_client.android.AndroidElement.replaceValue(..))  || execution(* io.appium.java_client.MobileElement.setValue(..))";
    private static final String EXECUTION_SCRIPT = "execution(* org.openqa.selenium.JavascriptExecutor.executeScript(..)) || execution(* org.openqa.selenium.JavascriptExecutor.executeAsyncScript(..))";
    private static final String EXECUTION_ALERT_ACCEPT = "execution(* org.openqa.selenium.Alert.accept(..))";
    private static final String EXECUTION_ALERT_DISMISS = "execution(* org.openqa.selenium.Alert.dismiss(..))";
    private static final String EXECUTION_ALERT_SEND_KEYS = "execution(* org.openqa.selenium.Alert.sendKeys(..))";
    private static final String EXECUTION_WINDOW_SET_SIZE = "execution(* org.openqa.selenium.WebDriver.Window.setSize(..))";
    private static final String EXECUTION_WINDOW_SET_POSITION = "execution(* org.openqa.selenium.WebDriver.Window.setPosition(..))";
    private static final String EXECUTION_WINDOW_MAXIMIZE = "execution(* org.openqa.selenium.WebDriver.Window.maximize(..))";
    private static final String EXECUTION_ROTATE = "execution(* org.openqa.selenium.Rotatable.rotate(..))";
    private static final String EXECUTION_CONTEXT = "execution(* org.openqa.selenium.ContextAware.context(..))";
    private static final String EXECUTION_SWITCH_TO_WINDOW = "execution(* org.openqa.selenium.WebDriver.TargetLocator.window(..))";
    private static final String EXECUTION_TAKE_SCREENSHOT_AS = "execution(* org.openqa.selenium.TakesScreenshot.getScreenshotAs(..))";
    private static final String AROUND = "execution(* org.openqa.selenium.WebDriver.*(..)) || execution(* org.openqa.selenium.WebElement.*(..)) || execution(* org.openqa.selenium.WebDriver.Navigation.*(..)) || execution(* org.openqa.selenium.WebDriver.Options.*(..)) || execution(* org.openqa.selenium.WebDriver.TargetLocator.*(..)) || execution(* org.openqa.selenium.WebDriver.TargetLocator.*(..)) || execution(* org.openqa.selenium.JavascriptExecutor.*(..)) || execution(* org.openqa.selenium.ContextAware.*(..)) || execution(* io.appium.java_client.FindsByAccessibilityId.*(..)) || execution(* io.appium.java_client.FindsByAndroidUIAutomator.*(..)) || execution(* io.appium.java_client.FindsByIosUIAutomation.*(..)) || execution(* io.appium.java_client.FindsByWindowsAutomation.*(..)) || execution(* io.appium.java_client.FindsByIosNSPredicate.*(..)) || execution(* org.openqa.selenium.internal.FindsByClassName.*(..)) || execution(* org.openqa.selenium.internal.FindsByCssSelector.*(..)) || execution(* org.openqa.selenium.internal.FindsById.*(..)) || execution(* org.openqa.selenium.internal.FindsByLinkText.*(..)) || execution(* org.openqa.selenium.internal.FindsByName.*(..)) || execution(* org.openqa.selenium.internal.FindsByTagName.*(..)) || execution(* org.openqa.selenium.internal.FindsByXPath.*(..)) || execution(* org.openqa.selenium.WebDriver.Window.*(..)) || execution(* io.appium.java_client.android.AndroidElement.*(..)) || execution(* io.appium.java_client.ios.IOSElement.*(..)) || execution(* io.appium.java_client.android.AndroidDriver.*(..)) || execution(* io.appium.java_client.ios.IOSDriver.*(..)) || execution(* io.appium.java_client.AppiumDriver.*(..)) || execution(* io.appium.java_client.MobileElement.*(..)) || execution(* org.openqa.selenium.remote.RemoteWebDriver.*(..)) || execution(* org.openqa.selenium.remote.RemoteWebElement.*(..)) || execution(* org.openqa.selenium.Alert.*(..)) || execution(* org.openqa.selenium.TakesScreenshot.*(..))";
    private final AbstractApplicationContext context;
    private final WebDriver driver;
    private final DefaultListener listener = new DefaultListener();

    private static Throwable getRootCause(Throwable thrown) {
        Class<?> throwableClass = thrown.getClass();
        if (!InvocationTargetException.class.equals(throwableClass) && !RuntimeException.class.equals(throwableClass)) {
            return thrown;
        }
        if (thrown.getCause() != null) {
            return DefaultAspect.getRootCause(thrown.getCause());
        }
        return thrown;
    }

    private static Class<?> getClassForProxy(Class<?> classOfObject) {
        Class<?> returnStatement = null;
        for (Class<?> c : listenable) {
            if (!c.isAssignableFrom(classOfObject)) continue;
            returnStatement = c;
        }
        return returnStatement;
    }

    DefaultAspect(AbstractApplicationContext context, WebDriver driver) {
        this.context = context;
        this.driver = driver;
    }

    private Object transformToListenable(Object toBeTransformed) {
        if (toBeTransformed == null) {
            return null;
        }
        Object result = toBeTransformed;
        if (DefaultAspect.getClassForProxy(toBeTransformed.getClass()) != null) {
            result = this.context.getBean("component", toBeTransformed);
        }
        return result;
    }

    private List<Object> returnProxyList(List<Object> originalList) {
        ArrayList<Object> proxyList = new ArrayList<Object>();
        for (Object o : originalList) {
            if (DefaultAspect.getClassForProxy(o.getClass()) == null) {
                proxyList.add(o);
                continue;
            }
            proxyList.add(this.context.getBean("component", o));
        }
        return proxyList;
    }

    public void add(Collection<Listener> listeners) {
        this.listener.add(listeners);
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.Navigation.get(..))  || execution(* org.openqa.selenium.WebDriver.Navigation.to(..)) || execution(* org.openqa.selenium.WebDriver.get(..))")
    public void beforeNavigateTo(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeNavigateTo(String.valueOf(joinPoint.getArgs()[0]), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.Navigation.get(..))  || execution(* org.openqa.selenium.WebDriver.Navigation.to(..)) || execution(* org.openqa.selenium.WebDriver.get(..))")
    public void afterNavigateTo(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterNavigateTo(String.valueOf(joinPoint.getArgs()[0]), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.Navigation.back(..))")
    public void beforeNavigateBack(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeNavigateBack(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.Navigation.back(..))")
    public void afterNavigateBack(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterNavigateBack(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.Navigation.forward(..))")
    public void beforeNavigateForward(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeNavigateForward(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.Navigation.forward(..))")
    public void afterNavigateForward(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterNavigateForward(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.Navigation.refresh(..))")
    public void beforeNavigateRefresh(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeNavigateRefresh(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.Navigation.refresh(..))")
    public void afterNavigateRefresh(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterNavigateRefresh(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    private <T> T castArgument(JoinPoint joinPoint, int argIndex) {
        return (T)joinPoint.getArgs()[argIndex];
    }

    private <T> T castTarget(JoinPoint joinPoint) {
        return (T)joinPoint.getTarget();
    }

    @Before(value="execution(* org.openqa.selenium.SearchContext.findElement(..)) || execution(* org.openqa.selenium.SearchContext.findElements(..))")
    public void beforeFindBy(JoinPoint joinPoint) throws Throwable {
        try {
            Object target = joinPoint.getTarget();
            if (!WebElement.class.isAssignableFrom(target.getClass())) {
                this.listener.beforeFindBy((By)this.castArgument(joinPoint, 0), null, this.driver);
            } else {
                this.listener.beforeFindBy((By)this.castArgument(joinPoint, 0), (WebElement)this.castTarget(joinPoint), this.driver);
            }
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.SearchContext.findElement(..)) || execution(* org.openqa.selenium.SearchContext.findElements(..))")
    public void afterFindBy(JoinPoint joinPoint) throws Throwable {
        try {
            Object target = joinPoint.getTarget();
            if (!WebElement.class.isAssignableFrom(target.getClass())) {
                this.listener.afterFindBy((By)this.castArgument(joinPoint, 0), null, this.driver);
            } else {
                this.listener.afterFindBy((By)this.castArgument(joinPoint, 0), (WebElement)this.castTarget(joinPoint), this.driver);
            }
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebElement.click(..))")
    public void beforeClickOn(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeClickOn((WebElement)this.castTarget(joinPoint), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebElement.click(..))")
    public void afterClickOn(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterClickOn((WebElement)this.castTarget(joinPoint), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebElement.sendKeys(..)) || execution(* org.openqa.selenium.WebElement.clear(..))  || execution(* io.appium.java_client.android.AndroidElement.replaceValue(..))  || execution(* io.appium.java_client.MobileElement.setValue(..))")
    public void beforeChangeValueOf(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeChangeValueOf((WebElement)this.castTarget(joinPoint), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebElement.sendKeys(..)) || execution(* org.openqa.selenium.WebElement.clear(..))  || execution(* io.appium.java_client.android.AndroidElement.replaceValue(..))  || execution(* io.appium.java_client.MobileElement.setValue(..))")
    public void afterChangeValueOf(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterChangeValueOf((WebElement)this.castTarget(joinPoint), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.JavascriptExecutor.executeScript(..)) || execution(* org.openqa.selenium.JavascriptExecutor.executeAsyncScript(..))")
    public void beforeScript(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeScript(String.valueOf(joinPoint.getArgs()[0]), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.JavascriptExecutor.executeScript(..)) || execution(* org.openqa.selenium.JavascriptExecutor.executeAsyncScript(..))")
    public void afterScript(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterScript(String.valueOf(joinPoint.getArgs()[0]), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.Alert.accept(..))")
    public void beforeAlertAccept(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeAlertAccept(this.driver, (Alert)this.castTarget(joinPoint));
            this.listener.beforeAlertAccept(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.Alert.accept(..))")
    public void afterAlertAccept(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterAlertAccept(this.driver, (Alert)this.castTarget(joinPoint));
            this.listener.afterAlertAccept(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.Alert.dismiss(..))")
    public void beforeAlertDismiss(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeAlertDismiss(this.driver, (Alert)this.castTarget(joinPoint));
            this.listener.beforeAlertDismiss(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.Alert.dismiss(..))")
    public void afterAlertDismiss(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterAlertDismiss(this.driver, (Alert)this.castTarget(joinPoint));
            this.listener.afterAlertDismiss(this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.Alert.sendKeys(..))")
    public void beforeAlertSendKeys(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeAlertSendKeys(this.driver, (Alert)this.castTarget(joinPoint), String.valueOf(joinPoint.getArgs()[0]));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.Alert.sendKeys(..))")
    public void afterAlertSendKeys(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterAlertSendKeys(this.driver, (Alert)this.castTarget(joinPoint), String.valueOf(joinPoint.getArgs()[0]));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.Window.setSize(..))")
    public void beforeWindowIsResized(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeWindowChangeSize(this.driver, (WebDriver.Window)this.castTarget(joinPoint), (Dimension)this.castArgument(joinPoint, 0));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.Window.setSize(..))")
    public void afterWindowIsResized(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterWindowChangeSize(this.driver, (WebDriver.Window)this.castTarget(joinPoint), (Dimension)this.castArgument(joinPoint, 0));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.Window.setPosition(..))")
    public void beforeWindowIsMoved(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeWindowIsMoved(this.driver, (WebDriver.Window)this.castTarget(joinPoint), (Point)this.castArgument(joinPoint, 0));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.Window.setPosition(..))")
    public void afterWindowIsMoved(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterWindowIsMoved(this.driver, (WebDriver.Window)this.castTarget(joinPoint), (Point)this.castArgument(joinPoint, 0));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.Window.maximize(..))")
    public void beforeMaximization(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeWindowIsMaximized(this.driver, (WebDriver.Window)this.castTarget(joinPoint));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.Window.maximize(..))")
    public void afterMaximization(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterWindowIsMaximized(this.driver, (WebDriver.Window)this.castTarget(joinPoint));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.WebDriver.TargetLocator.window(..))")
    public void beforeSwitchToWindow(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeSwitchToWindow((String)this.castArgument(joinPoint, 0), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.WebDriver.TargetLocator.window(..))")
    public void afterSwitchToWindow(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterSwitchToWindow((String)this.castArgument(joinPoint, 0), this.driver);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.TakesScreenshot.getScreenshotAs(..))")
    public void beforeTakeScreenShot(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeGetScreenshotAs((OutputType)this.castArgument(joinPoint, 0));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @AfterReturning(value="execution(* org.openqa.selenium.TakesScreenshot.getScreenshotAs(..))", returning="result")
    public void afterTakeScreenShot(JoinPoint joinPoint, Object result) throws Throwable {
        try {
            this.listener.afterGetScreenshotAs((OutputType)this.castArgument(joinPoint, 0), result);
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.Rotatable.rotate(..))")
    public void beforeRotation(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeRotation(this.driver, (ScreenOrientation)((Object)this.castArgument(joinPoint, 0)));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.Rotatable.rotate(..))")
    public void afterRotation(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterRotation(this.driver, (ScreenOrientation)((Object)this.castArgument(joinPoint, 0)));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Before(value="execution(* org.openqa.selenium.ContextAware.context(..))")
    public void beforeSwitchingToContext(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.beforeSwitchingToContext(this.driver, String.valueOf(joinPoint.getArgs()[0]));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @After(value="execution(* org.openqa.selenium.ContextAware.context(..))")
    public void afterSwitchingToContextn(JoinPoint joinPoint) throws Throwable {
        try {
            this.listener.afterSwitchingToContext(this.driver, String.valueOf(joinPoint.getArgs()[0]));
        }
        catch (Throwable t) {
            throw DefaultAspect.getRootCause(t);
        }
    }

    @Around(value="execution(* org.openqa.selenium.WebDriver.*(..)) || execution(* org.openqa.selenium.WebElement.*(..)) || execution(* org.openqa.selenium.WebDriver.Navigation.*(..)) || execution(* org.openqa.selenium.WebDriver.Options.*(..)) || execution(* org.openqa.selenium.WebDriver.TargetLocator.*(..)) || execution(* org.openqa.selenium.WebDriver.TargetLocator.*(..)) || execution(* org.openqa.selenium.JavascriptExecutor.*(..)) || execution(* org.openqa.selenium.ContextAware.*(..)) || execution(* io.appium.java_client.FindsByAccessibilityId.*(..)) || execution(* io.appium.java_client.FindsByAndroidUIAutomator.*(..)) || execution(* io.appium.java_client.FindsByIosUIAutomation.*(..)) || execution(* io.appium.java_client.FindsByWindowsAutomation.*(..)) || execution(* io.appium.java_client.FindsByIosNSPredicate.*(..)) || execution(* org.openqa.selenium.internal.FindsByClassName.*(..)) || execution(* org.openqa.selenium.internal.FindsByCssSelector.*(..)) || execution(* org.openqa.selenium.internal.FindsById.*(..)) || execution(* org.openqa.selenium.internal.FindsByLinkText.*(..)) || execution(* org.openqa.selenium.internal.FindsByName.*(..)) || execution(* org.openqa.selenium.internal.FindsByTagName.*(..)) || execution(* org.openqa.selenium.internal.FindsByXPath.*(..)) || execution(* org.openqa.selenium.WebDriver.Window.*(..)) || execution(* io.appium.java_client.android.AndroidElement.*(..)) || execution(* io.appium.java_client.ios.IOSElement.*(..)) || execution(* io.appium.java_client.android.AndroidDriver.*(..)) || execution(* io.appium.java_client.ios.IOSDriver.*(..)) || execution(* io.appium.java_client.AppiumDriver.*(..)) || execution(* io.appium.java_client.MobileElement.*(..)) || execution(* org.openqa.selenium.remote.RemoteWebDriver.*(..)) || execution(* org.openqa.selenium.remote.RemoteWebElement.*(..)) || execution(* org.openqa.selenium.Alert.*(..)) || execution(* org.openqa.selenium.TakesScreenshot.*(..))")
    public Object doAround(ProceedingJoinPoint point) throws Throwable {
        Throwable t = null;
        Object result = null;
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            t = e;
        }
        if (t != null) {
            Throwable rootCause = DefaultAspect.getRootCause(t);
            this.listener.onException(rootCause, this.driver);
            throw rootCause;
        }
        if (result == null) {
            return null;
        }
        if (List.class.isAssignableFrom(result.getClass())) {
            return this.returnProxyList((List)result);
        }
        return this.transformToListenable(result);
    }
}

