/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.clipboard;

import com.google.common.base.Preconditions;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.clipboard.ClipboardContentType;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Base64;

public interface HasClipboard
extends ExecutesMethod {
    default public void setClipboard(ClipboardContentType contentType, byte[] base64Content) {
        String[] parameters = new String[]{"content", "contentType"};
        Object[] values = new Object[]{new String(Preconditions.checkNotNull(base64Content), StandardCharsets.UTF_8), contentType.name().toLowerCase()};
        CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.SET_CLIPBOARD, MobileCommand.prepareArguments(parameters, values)));
    }

    default public String getClipboard(ClipboardContentType contentType) {
        return (String)CommandExecutionHelper.execute((ExecutesMethod)this, new AbstractMap.SimpleEntry(MobileCommand.GET_CLIPBOARD, MobileCommand.prepareArguments("contentType", contentType.name().toLowerCase())));
    }

    default public void setClipboardText(String text) {
        this.setClipboard(ClipboardContentType.PLAINTEXT, Base64.getMimeEncoder().encode(text.getBytes(StandardCharsets.UTF_8)));
    }

    default public String getClipboardText() {
        byte[] base64decodedBytes = Base64.getMimeDecoder().decode(this.getClipboard(ClipboardContentType.PLAINTEXT));
        return new String(base64decodedBytes, StandardCharsets.UTF_8);
    }
}

