/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class Activity {
    private final String appPackage;
    private final String appActivity;
    private String appWaitPackage;
    private String appWaitActivity;
    private String intentAction;
    private String intentCategory;
    private String intentFlags;
    private String optionalIntentArguments;
    private boolean stopApp;

    public Activity(String appPackage, String appActivity) {
        Preconditions.checkArgument(!StringUtils.isBlank(appPackage), "App package should be defined as not empty or null string");
        Preconditions.checkArgument(!StringUtils.isBlank(appActivity), "App activity should be defined as not empty or null string");
        this.appPackage = appPackage;
        this.appActivity = appActivity;
        this.stopApp = true;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public String getAppActivity() {
        return this.appActivity;
    }

    public String getAppWaitPackage() {
        return this.appWaitPackage;
    }

    public Activity setAppWaitPackage(String appWaitPackage) {
        this.appWaitPackage = appWaitPackage;
        return this;
    }

    public String getAppWaitActivity() {
        return this.appWaitActivity;
    }

    public Activity setAppWaitActivity(String appWaitActivity) {
        this.appWaitActivity = appWaitActivity;
        return this;
    }

    public String getIntentAction() {
        return this.intentAction;
    }

    public Activity setIntentAction(String intentAction) {
        this.intentAction = intentAction;
        return this;
    }

    public String getIntentCategory() {
        return this.intentCategory;
    }

    public Activity setIntentCategory(String intentCategory) {
        this.intentCategory = intentCategory;
        return this;
    }

    public String getIntentFlags() {
        return this.intentFlags;
    }

    public Activity setIntentFlags(String intentFlags) {
        this.intentFlags = intentFlags;
        return this;
    }

    public String getOptionalIntentArguments() {
        return this.optionalIntentArguments;
    }

    public Activity setOptionalIntentArguments(String optionalIntentArguments) {
        this.optionalIntentArguments = optionalIntentArguments;
        return this;
    }

    public boolean isStopApp() {
        return this.stopApp;
    }

    public Activity setStopApp(boolean stopApp) {
        this.stopApp = stopApp;
        return this;
    }

    public String toString() {
        return "Activity{appPackage='" + this.appPackage + '\'' + ", appActivity='" + this.appActivity + '\'' + ", appWaitPackage='" + this.appWaitPackage + '\'' + ", appWaitActivity='" + this.appWaitActivity + '\'' + ", intentAction='" + this.intentAction + '\'' + ", intentCategory='" + this.intentCategory + '\'' + ", intentFlags='" + this.intentFlags + '\'' + ", optionalIntentArguments='" + this.optionalIntentArguments + '\'' + ", stopApp=" + this.stopApp + '}';
    }
}

