/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumCommandInfo;
import io.appium.java_client.Setting;
import io.appium.java_client.imagecomparison.BaseComparisonOptions;
import io.appium.java_client.imagecomparison.ComparisonMode;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import io.appium.java_client.screenrecording.BaseStopScreenRecordingOptions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.http.HttpMethod;

public class MobileCommand {
    protected static final String RESET = "reset";
    protected static final String GET_STRINGS = "getStrings";
    protected static final String SET_VALUE = "setValue";
    protected static final String PULL_FILE = "pullFile";
    protected static final String PULL_FOLDER = "pullFolder";
    public static final String RUN_APP_IN_BACKGROUND = "runAppInBackground";
    protected static final String PERFORM_TOUCH_ACTION = "performTouchAction";
    protected static final String PERFORM_MULTI_TOUCH = "performMultiTouch";
    protected static final String LAUNCH_APP = "launchApp";
    protected static final String CLOSE_APP = "closeApp";
    protected static final String GET_DEVICE_TIME = "getDeviceTime";
    protected static final String GET_SESSION = "getSession";
    protected static final String IS_APP_INSTALLED = "isAppInstalled";
    protected static final String INSTALL_APP;
    protected static final String ACTIVATE_APP;
    protected static final String QUERY_APP_STATE;
    protected static final String TERMINATE_APP;
    protected static final String REMOVE_APP;
    public static final String GET_CLIPBOARD;
    public static final String SET_CLIPBOARD;
    protected static final String GET_PERFORMANCE_DATA;
    protected static final String GET_SUPPORTED_PERFORMANCE_DATA_TYPES;
    public static final String START_RECORDING_SCREEN;
    public static final String STOP_RECORDING_SCREEN;
    protected static final String HIDE_KEYBOARD;
    protected static final String LOCK;
    protected static final String SHAKE;
    protected static final String TOUCH_ID;
    protected static final String TOUCH_ID_ENROLLMENT;
    protected static final String CURRENT_ACTIVITY;
    protected static final String END_TEST_COVERAGE;
    protected static final String GET_DISPLAY_DENSITY;
    protected static final String GET_NETWORK_CONNECTION;
    protected static final String GET_SYSTEM_BARS;
    protected static final String IS_KEYBOARD_SHOWN;
    protected static final String IS_LOCKED;
    public static final String LONG_PRESS_KEY_CODE;
    protected static final String FINGER_PRINT;
    protected static final String OPEN_NOTIFICATIONS;
    public static final String PRESS_KEY_CODE;
    protected static final String PUSH_FILE;
    protected static final String SET_NETWORK_CONNECTION;
    protected static final String START_ACTIVITY;
    protected static final String TOGGLE_LOCATION_SERVICES;
    protected static final String UNLOCK;
    protected static final String REPLACE_VALUE;
    protected static final String GET_SETTINGS;
    protected static final String SET_SETTINGS;
    protected static final String GET_CURRENT_PACKAGE;
    protected static final String SEND_SMS;
    protected static final String GSM_CALL;
    protected static final String GSM_SIGNAL;
    protected static final String GSM_VOICE;
    protected static final String NETWORK_SPEED;
    protected static final String POWER_CAPACITY;
    protected static final String POWER_AC_STATE;
    protected static final String TOGGLE_WIFI;
    protected static final String TOGGLE_AIRPLANE_MODE;
    protected static final String TOGGLE_DATA;
    protected static final String COMPARE_IMAGES;
    public static final Map<String, CommandInfo> commandRepository;

    static {
        QUERY_APP_STATE = "queryAppState";
        TERMINATE_APP = "terminateApp";
        ACTIVATE_APP = "activateApp";
        REMOVE_APP = "removeApp";
        INSTALL_APP = "installApp";
        SET_CLIPBOARD = "setClipboard";
        GET_CLIPBOARD = "getClipboard";
        GET_PERFORMANCE_DATA = "getPerformanceData";
        GET_SUPPORTED_PERFORMANCE_DATA_TYPES = "getSuppportedPerformanceDataTypes";
        START_RECORDING_SCREEN = "startRecordingScreen";
        STOP_RECORDING_SCREEN = "stopRecordingScreen";
        HIDE_KEYBOARD = "hideKeyboard";
        LOCK = "lock";
        SHAKE = "shake";
        TOUCH_ID = "touchId";
        TOUCH_ID_ENROLLMENT = "toggleEnrollTouchId";
        CURRENT_ACTIVITY = "currentActivity";
        END_TEST_COVERAGE = "endTestCoverage";
        GET_DISPLAY_DENSITY = "getDisplayDensity";
        GET_NETWORK_CONNECTION = "getNetworkConnection";
        GET_SYSTEM_BARS = "getSystemBars";
        IS_KEYBOARD_SHOWN = "isKeyboardShown";
        IS_LOCKED = "isLocked";
        LONG_PRESS_KEY_CODE = "longPressKeyCode";
        FINGER_PRINT = "fingerPrint";
        OPEN_NOTIFICATIONS = "openNotifications";
        PRESS_KEY_CODE = "pressKeyCode";
        PUSH_FILE = "pushFile";
        SET_NETWORK_CONNECTION = "setNetworkConnection";
        START_ACTIVITY = "startActivity";
        TOGGLE_LOCATION_SERVICES = "toggleLocationServices";
        UNLOCK = "unlock";
        REPLACE_VALUE = "replaceValue";
        GET_SETTINGS = "getSettings";
        SET_SETTINGS = "setSettings";
        GET_CURRENT_PACKAGE = "getCurrentPackage";
        SEND_SMS = "sendSMS";
        GSM_CALL = "gsmCall";
        GSM_SIGNAL = "gsmSignal";
        GSM_VOICE = "gsmVoice";
        NETWORK_SPEED = "networkSpeed";
        POWER_CAPACITY = "powerCapacity";
        POWER_AC_STATE = "powerAC";
        TOGGLE_WIFI = "toggleWiFi";
        TOGGLE_AIRPLANE_MODE = "toggleFlightMode";
        TOGGLE_DATA = "toggleData";
        COMPARE_IMAGES = "compareImages";
        commandRepository = new HashMap<String, CommandInfo>();
        commandRepository.put(RESET, MobileCommand.postC("/session/:sessionId/appium/app/reset"));
        commandRepository.put(GET_STRINGS, MobileCommand.postC("/session/:sessionId/appium/app/strings"));
        commandRepository.put(SET_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/value"));
        commandRepository.put(PULL_FILE, MobileCommand.postC("/session/:sessionId/appium/device/pull_file"));
        commandRepository.put(PULL_FOLDER, MobileCommand.postC("/session/:sessionId/appium/device/pull_folder"));
        commandRepository.put(HIDE_KEYBOARD, MobileCommand.postC("/session/:sessionId/appium/device/hide_keyboard"));
        commandRepository.put(RUN_APP_IN_BACKGROUND, MobileCommand.postC("/session/:sessionId/appium/app/background"));
        commandRepository.put(PERFORM_TOUCH_ACTION, MobileCommand.postC("/session/:sessionId/touch/perform"));
        commandRepository.put(PERFORM_MULTI_TOUCH, MobileCommand.postC("/session/:sessionId/touch/multi/perform"));
        commandRepository.put(LAUNCH_APP, MobileCommand.postC("/session/:sessionId/appium/app/launch"));
        commandRepository.put(CLOSE_APP, MobileCommand.postC("/session/:sessionId/appium/app/close"));
        commandRepository.put(LOCK, MobileCommand.postC("/session/:sessionId/appium/device/lock"));
        commandRepository.put(GET_SETTINGS, MobileCommand.getC("/session/:sessionId/appium/settings"));
        commandRepository.put(SET_SETTINGS, MobileCommand.postC("/session/:sessionId/appium/settings"));
        commandRepository.put(GET_DEVICE_TIME, MobileCommand.getC("/session/:sessionId/appium/device/system_time"));
        commandRepository.put(GET_SESSION, MobileCommand.getC("/session/:sessionId/"));
        commandRepository.put(GET_SUPPORTED_PERFORMANCE_DATA_TYPES, MobileCommand.postC("/session/:sessionId/appium/performanceData/types"));
        commandRepository.put(GET_PERFORMANCE_DATA, MobileCommand.postC("/session/:sessionId/appium/getPerformanceData"));
        commandRepository.put(START_RECORDING_SCREEN, MobileCommand.postC("/session/:sessionId/appium/start_recording_screen"));
        commandRepository.put(STOP_RECORDING_SCREEN, MobileCommand.postC("/session/:sessionId/appium/stop_recording_screen"));
        commandRepository.put(IS_APP_INSTALLED, MobileCommand.postC("/session/:sessionId/appium/device/app_installed"));
        commandRepository.put(INSTALL_APP, MobileCommand.postC("/session/:sessionId/appium/device/install_app"));
        commandRepository.put(ACTIVATE_APP, MobileCommand.postC("/session/:sessionId/appium/device/activate_app"));
        commandRepository.put(REMOVE_APP, MobileCommand.postC("/session/:sessionId/appium/device/remove_app"));
        commandRepository.put(TERMINATE_APP, MobileCommand.postC("/session/:sessionId/appium/device/terminate_app"));
        commandRepository.put(QUERY_APP_STATE, MobileCommand.postC("/session/:sessionId/appium/device/app_state"));
        commandRepository.put(GET_CLIPBOARD, MobileCommand.postC("/session/:sessionId/appium/device/get_clipboard"));
        commandRepository.put(SET_CLIPBOARD, MobileCommand.postC("/session/:sessionId/appium/device/set_clipboard"));
        commandRepository.put(SHAKE, MobileCommand.postC("/session/:sessionId/appium/device/shake"));
        commandRepository.put(TOUCH_ID, MobileCommand.postC("/session/:sessionId/appium/simulator/touch_id"));
        commandRepository.put(TOUCH_ID_ENROLLMENT, MobileCommand.postC("/session/:sessionId/appium/simulator/toggle_touch_id_enrollment"));
        commandRepository.put(CURRENT_ACTIVITY, MobileCommand.getC("/session/:sessionId/appium/device/current_activity"));
        commandRepository.put(END_TEST_COVERAGE, MobileCommand.postC("/session/:sessionId/appium/app/end_test_coverage"));
        commandRepository.put(GET_DISPLAY_DENSITY, MobileCommand.getC("/session/:sessionId/appium/device/display_density"));
        commandRepository.put(GET_NETWORK_CONNECTION, MobileCommand.getC("/session/:sessionId/network_connection"));
        commandRepository.put(GET_SYSTEM_BARS, MobileCommand.getC("/session/:sessionId/appium/device/system_bars"));
        commandRepository.put(IS_KEYBOARD_SHOWN, MobileCommand.getC("/session/:sessionId/appium/device/is_keyboard_shown"));
        commandRepository.put(IS_LOCKED, MobileCommand.postC("/session/:sessionId/appium/device/is_locked"));
        commandRepository.put(LONG_PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/long_press_keycode"));
        commandRepository.put(FINGER_PRINT, MobileCommand.postC("/session/:sessionId/appium/device/finger_print"));
        commandRepository.put(OPEN_NOTIFICATIONS, MobileCommand.postC("/session/:sessionId/appium/device/open_notifications"));
        commandRepository.put(PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/press_keycode"));
        commandRepository.put(PUSH_FILE, MobileCommand.postC("/session/:sessionId/appium/device/push_file"));
        commandRepository.put(SET_NETWORK_CONNECTION, MobileCommand.postC("/session/:sessionId/network_connection"));
        commandRepository.put(START_ACTIVITY, MobileCommand.postC("/session/:sessionId/appium/device/start_activity"));
        commandRepository.put(TOGGLE_LOCATION_SERVICES, MobileCommand.postC("/session/:sessionId/appium/device/toggle_location_services"));
        commandRepository.put(UNLOCK, MobileCommand.postC("/session/:sessionId/appium/device/unlock"));
        commandRepository.put(REPLACE_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/replace_value"));
        commandRepository.put(GET_CURRENT_PACKAGE, MobileCommand.getC("/session/:sessionId/appium/device/current_package"));
        commandRepository.put(SEND_SMS, MobileCommand.postC("/session/:sessionId/appium/device/send_sms"));
        commandRepository.put(GSM_CALL, MobileCommand.postC("/session/:sessionId/appium/device/gsm_call"));
        commandRepository.put(GSM_SIGNAL, MobileCommand.postC("/session/:sessionId/appium/device/gsm_signal"));
        commandRepository.put(GSM_VOICE, MobileCommand.postC("/session/:sessionId/appium/device/gsm_voice"));
        commandRepository.put(NETWORK_SPEED, MobileCommand.postC("/session/:sessionId/appium/device/network_speed"));
        commandRepository.put(POWER_CAPACITY, MobileCommand.postC("/session/:sessionId/appium/device/power_capacity"));
        commandRepository.put(POWER_AC_STATE, MobileCommand.postC("/session/:sessionId/appium/device/power_ac"));
        commandRepository.put(TOGGLE_WIFI, MobileCommand.postC("/session/:sessionId/appium/device/toggle_wifi"));
        commandRepository.put(TOGGLE_AIRPLANE_MODE, MobileCommand.postC("/session/:sessionId/appium/device/toggle_airplane_mode"));
        commandRepository.put(TOGGLE_DATA, MobileCommand.postC("/session/:sessionId/appium/device/toggle_data"));
        commandRepository.put(COMPARE_IMAGES, MobileCommand.postC("/session/:sessionId/appium/compare_images"));
    }

    public static AppiumCommandInfo getC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.GET);
    }

    public static AppiumCommandInfo postC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.POST);
    }

    public static AppiumCommandInfo deleteC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.DELETE);
    }

    public static Map.Entry<String, Map<String, ?>> hideKeyboardCommand(String keyName) {
        return new AbstractMap.SimpleEntry(HIDE_KEYBOARD, MobileCommand.prepareArguments("keyName", keyName));
    }

    public static Map.Entry<String, Map<String, ?>> hideKeyboardCommand(String strategy, String keyName) {
        String[] parameters = new String[]{"strategy", "key"};
        Object[] values = new Object[]{strategy, keyName};
        return new AbstractMap.SimpleEntry(HIDE_KEYBOARD, MobileCommand.prepareArguments(parameters, values));
    }

    public static ImmutableMap<String, Object> prepareArguments(String param, Object value) {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        builder.put(param, value);
        return builder.build();
    }

    public static ImmutableMap<String, Object> prepareArguments(String[] params, Object[] values) {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        int i = 0;
        while (i < params.length) {
            if (!StringUtils.isBlank(params[i]) && values[i] != null) {
                builder.put(params[i], values[i]);
            }
            ++i;
        }
        return builder.build();
    }

    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key) {
        return new AbstractMap.SimpleEntry(PRESS_KEY_CODE, MobileCommand.prepareArguments("keycode", key));
    }

    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        return new AbstractMap.SimpleEntry(PRESS_KEY_CODE, MobileCommand.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key) {
        return new AbstractMap.SimpleEntry(LONG_PRESS_KEY_CODE, MobileCommand.prepareArguments("keycode", key));
    }

    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        return new AbstractMap.SimpleEntry(LONG_PRESS_KEY_CODE, MobileCommand.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> lockDeviceCommand(Duration duration) {
        return new AbstractMap.SimpleEntry(LOCK, MobileCommand.prepareArguments("seconds", duration.getSeconds()));
    }

    public static Map.Entry<String, Map<String, ?>> unlockDeviceCommand() {
        return new AbstractMap.SimpleEntry(UNLOCK, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getIsDeviceLockedCommand() {
        return new AbstractMap.SimpleEntry(IS_LOCKED, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getSettingsCommand() {
        return new AbstractMap.SimpleEntry(GET_SETTINGS, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> setSettingsCommand(Setting setting, Object value) {
        return new AbstractMap.SimpleEntry(SET_SETTINGS, MobileCommand.prepareArguments("settings", MobileCommand.prepareArguments(setting.toString(), value)));
    }

    public static Map.Entry<String, Map<String, ?>> pushFileCommand(String remotePath, byte[] base64Data) {
        String[] parameters = new String[]{"path", "data"};
        Object[] values = new Object[]{remotePath, new String(base64Data, StandardCharsets.UTF_8)};
        return new AbstractMap.SimpleEntry(PUSH_FILE, MobileCommand.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> startRecordingScreenCommand(BaseStartScreenRecordingOptions opts) {
        return new AbstractMap.SimpleEntry(START_RECORDING_SCREEN, MobileCommand.prepareArguments("options", opts.build()));
    }

    public static Map.Entry<String, Map<String, ?>> stopRecordingScreenCommand(BaseStopScreenRecordingOptions opts) {
        return new AbstractMap.SimpleEntry(STOP_RECORDING_SCREEN, MobileCommand.prepareArguments("options", opts.build()));
    }

    public static Map.Entry<String, Map<String, ?>> compareImagesCommand(ComparisonMode mode, byte[] img1Data, byte[] img2Data, @Nullable BaseComparisonOptions options) {
        Object[] objectArray;
        String[] stringArray;
        if (options == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "mode";
            stringArray2[1] = "firstImage";
            stringArray = stringArray2;
            stringArray2[2] = "secondImage";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "mode";
            stringArray3[1] = "firstImage";
            stringArray3[2] = "secondImage";
            stringArray = stringArray3;
            stringArray3[3] = "options";
        }
        String[] parameters = stringArray;
        if (options == null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = mode.toString();
            objectArray2[1] = new String(img1Data, StandardCharsets.UTF_8);
            objectArray = objectArray2;
            objectArray2[2] = new String(img2Data, StandardCharsets.UTF_8);
        } else {
            Object[] objectArray3 = new Object[4];
            objectArray3[0] = mode.toString();
            objectArray3[1] = new String(img1Data, StandardCharsets.UTF_8);
            objectArray3[2] = new String(img2Data, StandardCharsets.UTF_8);
            objectArray = objectArray3;
            objectArray3[3] = options.build();
        }
        Object[] values = objectArray;
        return new AbstractMap.SimpleEntry(COMPARE_IMAGES, MobileCommand.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> isKeyboardShownCommand() {
        return new AbstractMap.SimpleEntry(IS_KEYBOARD_SHOWN, ImmutableMap.of());
    }
}

