/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.Response;

public interface HasSessionDetails
extends ExecutesMethod {
    default public Map<String, Object> getSessionDetails() {
        Response response = this.execute(MobileCommand.GET_SESSION);
        Map resultMap = (Map)Map.class.cast(response.getValue());
        return ImmutableMap.builder().putAll(resultMap.entrySet().stream().filter(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            return !StringUtils.isBlank(key) && value != null && !StringUtils.isBlank(String.valueOf(value));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).build();
    }

    @Nullable
    default public Object getSessionDetail(String detail) {
        return this.getSessionDetails().get(detail);
    }

    @Nullable
    default public String getPlatformName() {
        Object platformName = Optional.ofNullable(this.getSessionDetail("platformName")).orElseGet(() -> this.getSessionDetail("platform"));
        return Optional.ofNullable(platformName).map(String::valueOf).orElse(null);
    }

    @Nullable
    default public String getAutomationName() {
        return Optional.ofNullable(this.getSessionDetail("automationName")).map(String::valueOf).orElse(null);
    }

    default public boolean isBrowser() {
        return Optional.ofNullable(this.getSessionDetail("browserName")).orElse(null) != null;
    }
}

