/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractFieldMapEntry;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldJoin;
import com.opencsv.exceptions.CsvBadConverterException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexToBeanField<T>
extends AbstractFieldMapEntry<String, String, T> {
    private final Pattern regex;

    public RegexToBeanField(String pattern, BeanField<T> field, Locale errorLocale) {
        super(field, errorLocale);
        try {
            this.regex = Pattern.compile(pattern, 2);
        }
        catch (PatternSyntaxException e) {
            CsvBadConverterException csve = new CsvBadConverterException(BeanFieldJoin.class, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("invalid.regex"));
            csve.initCause(e);
            throw csve;
        }
    }

    @Override
    public boolean contains(String key) {
        Matcher m3 = this.regex.matcher(key);
        return m3.matches();
    }

    @Override
    public String getInitializer() {
        return this.regex.pattern();
    }
}

