/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class ConverterDate
extends AbstractCsvConverter {
    private final SimpleDateFormat sdf;

    public ConverterDate(Class<?> type, String locale, Locale errorLocale, String formatString) {
        super(type, locale, errorLocale);
        this.sdf = this.locale != null ? new SimpleDateFormat(formatString, this.locale) : new SimpleDateFormat(formatString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> U convertDate(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o;
        if (value instanceof String) {
            try {
                Date d;
                SimpleDateFormat simpleDateFormat = this.sdf;
                synchronized (simpleDateFormat) {
                    d = this.sdf.parse((String)value);
                }
                o = fieldType.getConstructor(Long.TYPE).newInstance(d.getTime());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParseException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            String s2;
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                s2 = this.sdf.format((Date)value);
            }
            o = fieldType.cast(s2);
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> U convertCalendar(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o;
        if (value instanceof String) {
            Date d;
            try {
                SimpleDateFormat simpleDateFormat = this.sdf;
                synchronized (simpleDateFormat) {
                    d = this.sdf.parse((String)value);
                }
            }
            catch (ParseException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            if (fieldType == XMLGregorianCalendar.class) {
                try {
                    o = fieldType.cast(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
                }
                catch (DatatypeConfigurationException e) {
                    CsvDataTypeMismatchException ex = new CsvDataTypeMismatchException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("xmlgregoriancalendar.impossible"));
                    ex.initCause(e);
                    throw ex;
                }
            } else {
                o = fieldType.cast(gc);
            }
        } else {
            String s2;
            Calendar c;
            if (value instanceof XMLGregorianCalendar) {
                c = ((XMLGregorianCalendar)value).toGregorianCalendar();
            } else if (value instanceof Calendar) {
                c = (Calendar)value;
            } else {
                throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
            }
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                s2 = this.sdf.format(c.getTime());
            }
            o = fieldType.cast(s2);
        }
        return o;
    }

    private <U> U convertCommon(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o;
        Class<Object> conversionClass;
        Class<Object> clazz = conversionClass = fieldType == String.class ? value.getClass() : fieldType;
        if (Date.class.isAssignableFrom(conversionClass)) {
            o = this.convertDate(value, fieldType);
        } else if (Calendar.class.isAssignableFrom(conversionClass) || XMLGregorianCalendar.class.isAssignableFrom(conversionClass)) {
            o = this.convertCalendar(value, fieldType);
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
        }
        return o;
    }

    @Override
    public Object convertToRead(String value) throws CsvDataTypeMismatchException {
        return StringUtils.isBlank(value) ? null : this.convertCommon(value, this.type);
    }

    @Override
    public String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        return value == null ? null : this.convertCommon(value, String.class);
    }
}

