/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.ComplexFieldMapEntry;
import com.opencsv.bean.ConverterDate;
import com.opencsv.bean.ConverterNumber;
import com.opencsv.bean.ConverterPrimitiveTypes;
import com.opencsv.bean.CsvConverter;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.CsvNumber;
import com.opencsv.bean.FieldMap;
import com.opencsv.bean.HeaderIndex;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMappingStrategy<I, K, C extends ComplexFieldMapEntry<I, K, T>, T>
implements MappingStrategy<T> {
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Class<? extends T> type;
    protected final HeaderIndex headerIndex = new HeaderIndex();
    protected boolean annotationDriven;
    protected Locale errorLocale = Locale.getDefault();
    private final ConcurrentMap<Class<?>, PropertyEditor> editorMap = new ConcurrentHashMap();

    protected abstract Object chooseMultivaluedFieldIndexFromHeaderIndex(int var1);

    protected abstract FieldMap<I, K, ? extends C, T> getFieldMap();

    protected abstract void loadFieldMap() throws CsvBadConverterException;

    protected String checkForTrim(String s2, PropertyDescriptor prop) {
        return s2 != null && this.trimmableProperty(prop) ? s2.trim() : s2;
    }

    private boolean trimmableProperty(PropertyDescriptor prop) {
        return !prop.getPropertyType().getName().contains("String");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object convertValue(String value, PropertyDescriptor prop) throws InstantiationException, IllegalAccessException {
        PropertyEditor editor = this.getPropertyEditor(prop);
        Object obj = value;
        if (null != editor) {
            PropertyEditor propertyEditor = editor;
            synchronized (propertyEditor) {
                editor.setAsText(value);
                obj = editor.getValue();
            }
        }
        return obj;
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException, IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        return this.type.newInstance();
    }

    @Override
    @Deprecated
    public PropertyDescriptor findDescriptor(int col) {
        BeanField beanField = this.findField(col);
        if (beanField != null) {
            return this.findDescriptor(beanField.getField().getName());
        }
        String columnName = this.getColumnName(col);
        if (StringUtils.isNotBlank(columnName)) {
            return this.findDescriptor(columnName);
        }
        return null;
    }

    @Deprecated
    protected PropertyDescriptor findDescriptor(String name) {
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    public abstract String findHeader(int var1);

    @Override
    public int findMaxFieldIndex() {
        return this.headerIndex.findMaxIndex();
    }

    @Override
    public String[] generateHeader(T bean2) throws CsvRequiredFieldEmptyException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.before.header"));
        }
        if (this.headerIndex.isEmpty()) {
            String[] header = this.getFieldMap().generateHeader(bean2);
            this.headerIndex.initializeHeaderIndex(header);
            return header;
        }
        return this.headerIndex.getHeaderIndex();
    }

    protected PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor editor = (PropertyEditor)this.editorMap.get(cls);
        if (editor == null) {
            editor = PropertyEditorManager.findEditor(cls);
            this.editorMap.put(cls, editor);
        }
        return editor;
    }

    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }

    @Deprecated
    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors = this.loadDescriptors(this.getType())) {
            map.put(descriptor.getName().toUpperCase(), descriptor);
        }
        return map;
    }

    private PropertyDescriptor[] loadDescriptors(Class<? extends T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    public String getColumnName(int col) {
        return this.headerIndex.getByPosition(col);
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public T populateNewBean(String[] line) throws InstantiationException, IllegalAccessException, IntrospectionException, InvocationTargetException, CsvRequiredFieldEmptyException, CsvDataTypeMismatchException, CsvConstraintViolationException {
        this.verifyLineLength(line.length);
        T bean2 = this.createBean();
        for (int col = 0; col < line.length; ++col) {
            if (this.isAnnotationDriven()) {
                this.setFieldValue(bean2, line[col], col);
                continue;
            }
            this.processProperty(bean2, line, col);
        }
        return bean2;
    }

    @Override
    @Deprecated
    public T populateNewBeanWithIntrospection(String[] line) throws InstantiationException, IllegalAccessException, IntrospectionException, InvocationTargetException, CsvRequiredFieldEmptyException {
        this.verifyLineLength(line.length);
        T bean2 = this.createBean();
        for (int col = 0; col < line.length; ++col) {
            this.processProperty(bean2, line, col);
        }
        return bean2;
    }

    private void processProperty(T bean2, String[] line, int col) throws InstantiationException, IllegalAccessException, InvocationTargetException, CsvBadConverterException {
        PropertyDescriptor prop = this.findDescriptor(col);
        if (null != prop) {
            String value = this.checkForTrim(line[col], prop);
            Object obj = this.convertValue(value, prop);
            prop.getWriteMethod().invoke(bean2, obj);
        }
    }

    @Override
    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        this.type = type;
        this.loadFieldMap();
        try {
            this.descriptorMap = this.loadDescriptorMap();
        }
        catch (IntrospectionException e) {
            CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("bean.descriptors.uninitialized"));
            csve.initCause(e);
            throw csve;
        }
    }

    protected BeanField<T> instantiateCustomConverter(Class<? extends AbstractBeanField> converter) throws CsvBadConverterException {
        try {
            BeanField c = converter.newInstance();
            c.setErrorLocale(this.errorLocale);
            return c;
        }
        catch (IllegalAccessException | InstantiationException oldEx) {
            CsvBadConverterException newEx = new CsvBadConverterException(converter, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("custom.converter.invalid"), converter.getCanonicalName()));
            newEx.initCause(oldEx);
            throw newEx;
        }
    }

    @Override
    public boolean isAnnotationDriven() {
        return this.annotationDriven;
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        if (this.getFieldMap() != null) {
            this.getFieldMap().setErrorLocale(this.errorLocale);
            for (BeanField<T> f : this.getFieldMap().values()) {
                f.setErrorLocale(this.errorLocale);
            }
        }
    }

    protected void setFieldValue(T bean2, String value, int column) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        BeanField<T> beanField = this.findField(column);
        if (beanField != null) {
            beanField.setFieldValue(bean2, value, this.findHeader(column));
        }
    }

    @Override
    public String[] transmuteBean(T bean2) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        int numColumns = this.findMaxFieldIndex() + 1;
        List<String> transmutedBean = this.isAnnotationDriven() ? this.writeWithReflection(bean2, numColumns) : this.writeWithIntrospection(bean2, numColumns);
        return transmutedBean.toArray(new String[transmutedBean.size()]);
    }

    private List<String> writeWithReflection(T bean2, int numColumns) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        ArrayList<String> contents = new ArrayList<String>(numColumns > 0 ? numColumns : 0);
        int i = 0;
        while (i < numColumns) {
            String[] fields;
            BeanField<T> firstBeanField = this.findField(i);
            Object firstIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(i);
            String[] stringArray = fields = firstBeanField != null ? firstBeanField.write(bean2, firstIndex) : ArrayUtils.EMPTY_STRING_ARRAY;
            if (fields.length == 0) {
                contents.add("");
                ++i;
                continue;
            }
            contents.add(StringUtils.defaultString(fields[0]));
            int j = 1;
            int displacedIndex = i + j;
            BeanField subsequentBeanField = this.findField(displacedIndex);
            Object subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(displacedIndex);
            while (j < fields.length && displacedIndex < numColumns && Objects.equals(firstBeanField, subsequentBeanField) && Objects.equals(firstIndex, subsequentIndex)) {
                contents.add(StringUtils.defaultString(fields[j]));
                displacedIndex = i + ++j;
                subsequentBeanField = this.findField(displacedIndex);
                subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(displacedIndex);
            }
            i = displacedIndex;
            if (i >= numColumns) continue;
            subsequentBeanField = this.findField(i);
            subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(i);
            while (Objects.equals(firstBeanField, subsequentBeanField) && Objects.equals(firstIndex, subsequentIndex) && i < numColumns) {
                contents.add("");
                subsequentBeanField = this.findField(++i);
                subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(i);
            }
        }
        return contents;
    }

    private List<String> writeWithIntrospection(T bean2, int numColumns) {
        ArrayList<String> contents = new ArrayList<String>(numColumns > 0 ? numColumns : 0);
        for (int i = 0; i < numColumns; ++i) {
            try {
                PropertyDescriptor desc = this.findDescriptor(i);
                Object o = desc != null ? desc.getReadMethod().invoke(bean2, (Object[])null) : null;
                contents.add(Objects.toString(o, ""));
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean2, null, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("error.introspecting.beans"));
                csve.initCause(e);
                throw csve;
            }
        }
        return contents;
    }

    @Override
    @Deprecated
    public Integer getColumnIndex(String name) {
        int[] i = this.headerIndex.getByName(name);
        return i.length == 0 ? null : Integer.valueOf(i[0]);
    }

    protected CsvConverter determineConverter(Field field, Class<?> elementType, String locale) {
        AbstractCsvConverter converter;
        if (field.isAnnotationPresent(CsvDate.class)) {
            String formatString = field.getAnnotation(CsvDate.class).value();
            converter = new ConverterDate(elementType, locale, this.errorLocale, formatString);
        } else if (field.isAnnotationPresent(CsvNumber.class)) {
            String formatString = field.getAnnotation(CsvNumber.class).value();
            converter = new ConverterNumber(elementType, locale, this.errorLocale, formatString);
        } else {
            converter = new ConverterPrimitiveTypes(elementType, locale, this.errorLocale);
        }
        return converter;
    }
}

