/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.watcher;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModifiedFiles {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifiedFiles.class);
    private Set<Path> files = new HashSet<Path>();
    private long lastModified;

    ModifiedFiles() {
    }

    synchronized void ddd(Path file) {
        if (!file.toFile().isFile()) {
            return;
        }
        this.lastModified = file.toFile().lastModified();
        Path absPath = file.normalize().toAbsolutePath();
        log.debug("Add :{}", (Object)absPath);
        this.files.add(absPath);
    }

    synchronized Optional<Set<Path>> getChangedFilesWithinLast(long mills) {
        if (this.files.isEmpty()) {
            return Optional.empty();
        }
        if (System.currentTimeMillis() < this.lastModified + mills) {
            return Optional.empty();
        }
        HashSet<Path> result = new HashSet<Path>(this.files);
        this.files.clear();
        return Optional.of(result);
    }
}

