/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.watcher;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.sitoolkit.cv.core.infra.watcher.FileWatchEventListener;
import io.sitoolkit.cv.core.infra.watcher.ModifiedFiles;
import io.sitoolkit.cv.core.infra.watcher.WatchingFiles;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    private WatchingFiles watchingFiles = new WatchingFiles();
    private ModifiedFiles modifiedFiles = new ModifiedFiles();
    private final List<FileWatchEventListener> fileEventListeners = new ArrayList<FileWatchEventListener>();
    private WatchService watchService;
    private ExecutorService executorService;
    private volatile boolean watching = true;

    public void add(Path path) {
        if (!path.toFile().exists()) {
            log.warn("Path not found {}", (Object)path);
            return;
        }
        log.info("Start watching {}", (Object)path);
        if (path.toFile().isFile()) {
            this.watchFile(path);
        } else {
            try {
                this.watchDir(path);
                Files.walk(path, new FileVisitOption[0]).forEach(childPath -> {
                    if (childPath.toFile().isFile()) {
                        this.watchFile((Path)childPath);
                    } else {
                        this.watchDir((Path)childPath);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void start() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        this.executorService.execute(() -> {
            while (this.watching) {
                this.pollWatchEvent();
            }
        });
        this.executorService.execute(() -> {
            while (this.watching) {
                this.handleChangeEvent();
            }
        });
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public boolean isWatching(Path path) {
        return this.watchingFiles.contains(path);
    }

    private void watchFile(Path file) {
        if (this.watchingFiles.add(file)) {
            this.watchDir(file.getParent());
        }
    }

    private void watchDir(Path dir) {
        if (this.watchingFiles.add(dir)) {
            this.registerWatchService(dir);
        }
    }

    private void registerWatchService(Path dir) {
        try {
            if (this.watchService == null) {
                this.watchService = FileSystems.getDefault().newWatchService();
            }
            log.debug("Register WatchService to {}", (Object)dir);
            dir.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void pollWatchEvent() {
        WatchKey watchKey = null;
        if (this.watchService == null) {
            return;
        }
        try {
            watchKey = this.watchService.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            // empty catch block
        }
        if (watchKey == null) {
            return;
        }
        for (WatchEvent<?> event : watchKey.pollEvents()) {
            log.info("Poll watchEvent:{} of wachable:{}", event.kind(), (Object)watchKey.watchable());
            Path watchingPath = (Path)watchKey.watchable();
            Path effectedPath = watchingPath.resolve((Path)event.context());
            if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                this.add(effectedPath);
                this.modifiedFiles.ddd(effectedPath);
                continue;
            }
            if (StandardWatchEventKinds.ENTRY_MODIFY.equals(event.kind())) {
                this.modifiedFiles.ddd(effectedPath);
                continue;
            }
            if (!StandardWatchEventKinds.ENTRY_DELETE.equals(event.kind())) continue;
            this.watchingFiles.remove(effectedPath);
        }
        watchKey.reset();
    }

    private void handleChangeEvent() {
        try {
            TimeUnit.MILLISECONDS.sleep(300L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.modifiedFiles.getChangedFilesWithinLast(300L).ifPresent(files -> this.fileEventListeners.forEach(listener -> {
            try {
                log.info("Fire modify event to {} with {}", listener.getClass(), files);
                listener.onModify((Set<Path>)files);
            }
            catch (Exception e) {
                log.error("Exception in the process of file change event", (Throwable)e);
            }
        }));
    }

    public void addListener(FileWatchEventListener listener) {
        this.fileEventListeners.add(listener);
    }
}

