/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.util;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SignatureParser {
    private String packageName;
    private String simpleMedhod;

    public static SignatureParser parse(String signature) {
        SignatureParser parser = new SignatureParser();
        int leftRoundBracketsIndex = signature.indexOf("(");
        int methodStartPeriodIndex = signature.substring(0, leftRoundBracketsIndex).lastIndexOf(".");
        int classStartPeriodIndex = signature.substring(0, methodStartPeriodIndex).lastIndexOf(".");
        parser.setPackageName(signature.substring(0, classStartPeriodIndex));
        String methodParam = signature.substring(leftRoundBracketsIndex, signature.length());
        StringBuilder simpleMedhod = new StringBuilder();
        String classAndMedhod = signature.substring(classStartPeriodIndex + 1, leftRoundBracketsIndex + 1);
        simpleMedhod.append(classAndMedhod);
        for (String param : methodParam.split(",")) {
            simpleMedhod.append(StringUtils.substringAfterLast((String)param, (String)"."));
            if (param.endsWith(")")) continue;
            simpleMedhod.append(", ");
        }
        parser.setSimpleMedhod(simpleMedhod.toString());
        return parser;
    }

    @Generated
    public SignatureParser() {
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getSimpleMedhod() {
        return this.simpleMedhod;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setSimpleMedhod(String simpleMedhod) {
        this.simpleMedhod = simpleMedhod;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureParser)) {
            return false;
        }
        SignatureParser other = (SignatureParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$simpleMedhod = this.getSimpleMedhod();
        String other$simpleMedhod = other.getSimpleMedhod();
        return !(this$simpleMedhod == null ? other$simpleMedhod != null : !this$simpleMedhod.equals(other$simpleMedhod));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignatureParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $simpleMedhod = this.getSimpleMedhod();
        result = result * 59 + ($simpleMedhod == null ? 43 : $simpleMedhod.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignatureParser(packageName=" + this.getPackageName() + ", simpleMedhod=" + this.getSimpleMedhod() + ")";
    }
}

