/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.util;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public class PackageUtils {
    public static String getVersion() {
        String version = PackageUtils.class.getPackage().getImplementationVersion();
        if (version != null) {
            return version;
        }
        return PackageUtils.getVersionFromPomXml();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersionFromPomXml() {
        try (InputStream is = Files.newInputStream(Paths.get("pom.xml", new String[0]), new OpenOption[0]);){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            doc.getDocumentElement().normalize();
            String projectVersion = (String)XPathFactory.newInstance().newXPath().compile("/project/version").evaluate(doc, XPathConstants.STRING);
            if (StringUtils.isNotEmpty((CharSequence)projectVersion)) {
                String string2 = projectVersion;
                return string2;
            }
            String string = (String)XPathFactory.newInstance().newXPath().compile("/project/parent/version").evaluate(doc, XPathConstants.STRING);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Get version from pom.xml failed");
        }
    }
}

