/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.sitoolkit.cv.core.infra.util.SitFileUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static String obj2str(Object obj) {
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T> T str2obj(String str, Class<T> objType) {
        try {
            return (T)MAPPER.readValue(str, objType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T str2obj(String str, Object obj) {
        try {
            return (T)MAPPER.readerForUpdating(obj).readValue(str);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T url2obj(URL url, Class<T> objType) {
        try {
            return (T)MAPPER.readValue(url, objType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void obj2file(Object obj, Path path) {
        log.info("Write object to file: {}", (Object)JsonUtils.formatPath(path));
        try {
            SitFileUtils.createDirectories(path.getParent());
            MAPPER.writeValue(path.toFile(), obj);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> Optional<T> file2obj(Path path, Class<T> objType) {
        if (!path.toFile().exists()) {
            log.info("File doesn't exist: {}", (Object)JsonUtils.formatPath(path));
            return Optional.empty();
        }
        log.info("Read file to object: {}", (Object)JsonUtils.formatPath(path));
        try {
            return Optional.of(MAPPER.readValue(path.toFile(), objType));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> Optional<T> file2obj(Path path, TypeReference<T> objType) {
        if (!path.toFile().exists()) {
            log.info("File doesn't exist: {}", (Object)JsonUtils.formatPath(path));
            return Optional.empty();
        }
        log.info("Read file to object: {}", (Object)JsonUtils.formatPath(path));
        try {
            return Optional.of(MAPPER.readValue(path.toFile(), objType));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Path formatPath(Path path) {
        return path.toAbsolutePath().normalize();
    }

    public static <T> T merge(T original, Path path) {
        ObjectReader reader = MAPPER.readerForUpdating(original);
        try {
            return (T)reader.readValue(path.toFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

