/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.util;

import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;

public class CsvUtils {
    private CsvUtils() {
    }

    public static <T> void bean2csv(List<T> beans, Path csvFilePath) {
        try (FileWriter writer = new FileWriter(csvFilePath.toFile());){
            StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).build();
            beanToCsv.write(beans);
        }
        catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException | IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

