/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.project;

import io.sitoolkit.cv.core.infra.util.PackageUtils;
import io.sitoolkit.cv.core.infra.util.SitResourceUtils;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitCvToolsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SitCvToolsManager.class);
    private static final String ARTIFACT_ID = "sit-cv-tools";

    public static Path install(Path workDir, String javaVersion) {
        String jarName = SitCvToolsManager.resolveJarName(javaVersion);
        Path jarPath = workDir.resolve(jarName);
        log.info("Installing {}", (Object)ARTIFACT_ID);
        SitResourceUtils.res2file(SitCvToolsManager.class, "/lib/" + jarName, jarPath);
        return jarPath;
    }

    static String resolveJarName(String javaVersion) {
        return String.format("%s-%s-%s.jar", SitCvToolsManager.resolveArtifactId(javaVersion), PackageUtils.getVersion(), "jar-with-dependencies");
    }

    static String resolveArtifactId(String javaVersion) {
        if (StringUtils.startsWith((CharSequence)javaVersion, (CharSequence)"1.8")) {
            return "sit-cv-tools-1_8";
        }
        return ARTIFACT_ID;
    }
}

