/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class FilterPattern {
    private final boolean empty;
    private final Pattern pattern;
    private final boolean resultWhenPatternEmpty;
    private static final String EMPTY_STR = "";

    public FilterPattern(String patternString, boolean resultWhenPatternEmpty) {
        this.empty = StringUtils.isEmpty((CharSequence)patternString);
        this.resultWhenPatternEmpty = resultWhenPatternEmpty;
        this.pattern = this.empty ? null : Pattern.compile(patternString);
    }

    public boolean match(String value) {
        if (this.isEmpty()) {
            return this.resultWhenPatternEmpty;
        }
        return this.pattern.matcher(value).matches();
    }

    public String matchString(String value) {
        Matcher matcher = this.pattern.matcher(value);
        if (!matcher.matches() || matcher.groupCount() < 1) {
            return EMPTY_STR;
        }
        return matcher.group(1);
    }

    @Generated
    public boolean isEmpty() {
        return this.empty;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public boolean isResultWhenPatternEmpty() {
        return this.resultWhenPatternEmpty;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterPattern)) {
            return false;
        }
        FilterPattern other = (FilterPattern)o;
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        Pattern this$pattern = this.getPattern();
        Pattern other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        return this.isResultWhenPatternEmpty() == other.isResultWhenPatternEmpty();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEmpty() ? 79 : 97);
        Pattern $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        result = result * 59 + (this.isResultWhenPatternEmpty() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "FilterPattern(empty=" + this.isEmpty() + ", pattern=" + this.getPattern() + ", resultWhenPatternEmpty=" + this.isResultWhenPatternEmpty() + ")";
    }
}

