/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.config;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FilterCondition {
    private String name;
    private String annotation;
    private boolean withDetail = true;
    private Pattern namePattern;
    private Pattern annotationPattern;

    public boolean matchName(String name) {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            return true;
        }
        if (this.namePattern == null) {
            this.namePattern = Pattern.compile(this.name);
        }
        return this.namePattern.matcher(name).matches();
    }

    public boolean matchAnnotation(String annotation) {
        if (StringUtils.isEmpty((CharSequence)this.annotation)) {
            return true;
        }
        if (this.annotationPattern == null) {
            this.annotationPattern = Pattern.compile(this.annotation);
        }
        return this.annotationPattern.matcher(annotation).matches();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAnnotation() {
        return this.annotation;
    }

    @Generated
    public boolean isWithDetail() {
        return this.withDetail;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    @Generated
    public void setWithDetail(boolean withDetail) {
        this.withDetail = withDetail;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterCondition)) {
            return false;
        }
        FilterCondition other = (FilterCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$annotation = this.getAnnotation();
        String other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        if (this.isWithDetail() != other.isWithDetail()) {
            return false;
        }
        Pattern this$namePattern = this.namePattern;
        Pattern other$namePattern = other.namePattern;
        if (this$namePattern == null ? other$namePattern != null : !this$namePattern.equals(other$namePattern)) {
            return false;
        }
        Pattern this$annotationPattern = this.annotationPattern;
        Pattern other$annotationPattern = other.annotationPattern;
        return !(this$annotationPattern == null ? other$annotationPattern != null : !this$annotationPattern.equals(other$annotationPattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FilterCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
        result = result * 59 + (this.isWithDetail() ? 79 : 97);
        Pattern $namePattern = this.namePattern;
        result = result * 59 + ($namePattern == null ? 43 : $namePattern.hashCode());
        Pattern $annotationPattern = this.annotationPattern;
        result = result * 59 + ($annotationPattern == null ? 43 : $annotationPattern.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FilterCondition(name=" + this.getName() + ", annotation=" + this.getAnnotation() + ", withDetail=" + this.isWithDetail() + ", namePattern=" + this.namePattern + ", annotationPattern=" + this.annotationPattern + ")";
    }

    @Generated
    public FilterCondition() {
    }

    @Generated
    public FilterCondition(String name, String annotation, boolean withDetail, Pattern namePattern, Pattern annotationPattern) {
        this.name = name;
        this.annotation = annotation;
        this.withDetail = withDetail;
        this.namePattern = namePattern;
        this.annotationPattern = annotationPattern;
    }
}

