/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.config;

import io.sitoolkit.cv.core.infra.config.CvConfig;
import io.sitoolkit.cv.core.infra.config.CvConfigEventListener;
import io.sitoolkit.cv.core.infra.config.CvConfigReader;
import io.sitoolkit.cv.core.infra.watcher.FileWatcher;
import java.nio.file.Path;
import java.util.Optional;

public class CvConfigService {
    FileWatcher watcher = new FileWatcher();
    CvConfigReader reader = new CvConfigReader();

    public CvConfig read(Path dir, boolean watch) {
        Optional<Path> configFilePathOpt = this.reader.findConfigPath(dir);
        if (configFilePathOpt.isEmpty()) {
            return this.reader.readDefaultConfig();
        }
        Path configFilePath = configFilePathOpt.orElseThrow();
        CvConfig config = this.reader.read(configFilePath);
        if (watch) {
            this.watcher.add(configFilePath);
            this.watcher.addListener(modifiedFiles -> {
                CvConfig modifiedConfig = this.reader.read(configFilePath);
                config.update(modifiedConfig);
                config.getEventListeners().stream().forEach(CvConfigEventListener::onModify);
            });
            this.watcher.start();
        }
        return config;
    }
}

