/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonMerge;
import io.sitoolkit.cv.core.infra.config.CvConfigEventListener;
import io.sitoolkit.cv.core.infra.config.EnclosureFilterCondition;
import io.sitoolkit.cv.core.infra.config.FilterCondition;
import io.sitoolkit.cv.core.infra.config.FilterConditionGroup;
import io.sitoolkit.cv.core.infra.config.LifelineClasses;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;

public class CvConfig {
    @JsonIgnore
    private Path sourcePath;
    private String jarList = "jar-list.txt";
    private String javaFilePattern = ".*\\.(java|class)$";
    private boolean override = false;
    private boolean exception = true;
    private boolean showAccessor = false;
    @JsonMerge
    private List<LifelineClasses> lifelines = new ArrayList<LifelineClasses>();
    private EnclosureFilterCondition sqlLogPattern;
    @JsonMerge
    private List<String> asyncAnnotations = new ArrayList<String>();
    @JsonIgnore
    private List<CvConfigEventListener> eventListeners = new ArrayList<CvConfigEventListener>();

    public void update(CvConfig other) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)other);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public FilterConditionGroup getEntryPointFilter() {
        List<LifelineClasses> entryPoints = this.lifelines.stream().filter(LifelineClasses::isEntryPoint).collect(Collectors.toList());
        return this.toFilterConditionGroup(entryPoints);
    }

    public FilterConditionGroup getLifelineOnlyFilter() {
        List<LifelineClasses> repositories = this.lifelines.stream().filter(LifelineClasses::isLifelineOnly).collect(Collectors.toList());
        return this.toFilterConditionGroup(repositories);
    }

    public FilterConditionGroup getSequenceDiagramFilter() {
        return this.toFilterConditionGroup(this.lifelines);
    }

    public FilterConditionGroup getRepositoryFilter() {
        List<LifelineClasses> repositories = this.lifelines.stream().filter(LifelineClasses::isDbAccess).collect(Collectors.toList());
        return this.toFilterConditionGroup(repositories);
    }

    public EnclosureFilterCondition getSqlEnclosureFilter() {
        return this.sqlLogPattern;
    }

    public void addEventListener(CvConfigEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    private FilterConditionGroup toFilterConditionGroup(List<LifelineClasses> lifelines) {
        FilterConditionGroup fcg = new FilterConditionGroup();
        ArrayList<FilterCondition> include = new ArrayList<FilterCondition>();
        ArrayList<FilterCondition> exclude = new ArrayList<FilterCondition>();
        fcg.setInclude(include);
        fcg.setExclude(exclude);
        lifelines.forEach(lifeLine -> {
            include.add(lifeLine.getCondition());
            if (lifeLine.isExclude()) {
                exclude.add(lifeLine.getCondition());
            }
        });
        return fcg;
    }

    @Generated
    public CvConfig() {
    }

    @Generated
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Generated
    public String getJarList() {
        return this.jarList;
    }

    @Generated
    public String getJavaFilePattern() {
        return this.javaFilePattern;
    }

    @Generated
    public boolean isOverride() {
        return this.override;
    }

    @Generated
    public boolean isException() {
        return this.exception;
    }

    @Generated
    public boolean isShowAccessor() {
        return this.showAccessor;
    }

    @Generated
    public List<LifelineClasses> getLifelines() {
        return this.lifelines;
    }

    @Generated
    public EnclosureFilterCondition getSqlLogPattern() {
        return this.sqlLogPattern;
    }

    @Generated
    public List<String> getAsyncAnnotations() {
        return this.asyncAnnotations;
    }

    @Generated
    public List<CvConfigEventListener> getEventListeners() {
        return this.eventListeners;
    }

    @Generated
    public void setSourcePath(Path sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Generated
    public void setJarList(String jarList) {
        this.jarList = jarList;
    }

    @Generated
    public void setJavaFilePattern(String javaFilePattern) {
        this.javaFilePattern = javaFilePattern;
    }

    @Generated
    public void setOverride(boolean override) {
        this.override = override;
    }

    @Generated
    public void setException(boolean exception) {
        this.exception = exception;
    }

    @Generated
    public void setShowAccessor(boolean showAccessor) {
        this.showAccessor = showAccessor;
    }

    @Generated
    public void setLifelines(List<LifelineClasses> lifelines) {
        this.lifelines = lifelines;
    }

    @Generated
    public void setSqlLogPattern(EnclosureFilterCondition sqlLogPattern) {
        this.sqlLogPattern = sqlLogPattern;
    }

    @Generated
    public void setAsyncAnnotations(List<String> asyncAnnotations) {
        this.asyncAnnotations = asyncAnnotations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CvConfig)) {
            return false;
        }
        CvConfig other = (CvConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        String this$jarList = this.getJarList();
        String other$jarList = other.getJarList();
        if (this$jarList == null ? other$jarList != null : !this$jarList.equals(other$jarList)) {
            return false;
        }
        String this$javaFilePattern = this.getJavaFilePattern();
        String other$javaFilePattern = other.getJavaFilePattern();
        if (this$javaFilePattern == null ? other$javaFilePattern != null : !this$javaFilePattern.equals(other$javaFilePattern)) {
            return false;
        }
        if (this.isOverride() != other.isOverride()) {
            return false;
        }
        if (this.isException() != other.isException()) {
            return false;
        }
        if (this.isShowAccessor() != other.isShowAccessor()) {
            return false;
        }
        List<LifelineClasses> this$lifelines = this.getLifelines();
        List<LifelineClasses> other$lifelines = other.getLifelines();
        if (this$lifelines == null ? other$lifelines != null : !((Object)this$lifelines).equals(other$lifelines)) {
            return false;
        }
        EnclosureFilterCondition this$sqlLogPattern = this.getSqlLogPattern();
        EnclosureFilterCondition other$sqlLogPattern = other.getSqlLogPattern();
        if (this$sqlLogPattern == null ? other$sqlLogPattern != null : !((Object)this$sqlLogPattern).equals(other$sqlLogPattern)) {
            return false;
        }
        List<String> this$asyncAnnotations = this.getAsyncAnnotations();
        List<String> other$asyncAnnotations = other.getAsyncAnnotations();
        if (this$asyncAnnotations == null ? other$asyncAnnotations != null : !((Object)this$asyncAnnotations).equals(other$asyncAnnotations)) {
            return false;
        }
        List<CvConfigEventListener> this$eventListeners = this.getEventListeners();
        List<CvConfigEventListener> other$eventListeners = other.getEventListeners();
        return !(this$eventListeners == null ? other$eventListeners != null : !((Object)this$eventListeners).equals(other$eventListeners));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CvConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        String $jarList = this.getJarList();
        result = result * 59 + ($jarList == null ? 43 : $jarList.hashCode());
        String $javaFilePattern = this.getJavaFilePattern();
        result = result * 59 + ($javaFilePattern == null ? 43 : $javaFilePattern.hashCode());
        result = result * 59 + (this.isOverride() ? 79 : 97);
        result = result * 59 + (this.isException() ? 79 : 97);
        result = result * 59 + (this.isShowAccessor() ? 79 : 97);
        List<LifelineClasses> $lifelines = this.getLifelines();
        result = result * 59 + ($lifelines == null ? 43 : ((Object)$lifelines).hashCode());
        EnclosureFilterCondition $sqlLogPattern = this.getSqlLogPattern();
        result = result * 59 + ($sqlLogPattern == null ? 43 : ((Object)$sqlLogPattern).hashCode());
        List<String> $asyncAnnotations = this.getAsyncAnnotations();
        result = result * 59 + ($asyncAnnotations == null ? 43 : ((Object)$asyncAnnotations).hashCode());
        List<CvConfigEventListener> $eventListeners = this.getEventListeners();
        result = result * 59 + ($eventListeners == null ? 43 : ((Object)$eventListeners).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CvConfig(sourcePath=" + this.getSourcePath() + ", jarList=" + this.getJarList() + ", javaFilePattern=" + this.getJavaFilePattern() + ", override=" + this.isOverride() + ", exception=" + this.isException() + ", showAccessor=" + this.isShowAccessor() + ", lifelines=" + this.getLifelines() + ", sqlLogPattern=" + this.getSqlLogPattern() + ", asyncAnnotations=" + this.getAsyncAnnotations() + ", eventListeners=" + this.getEventListeners() + ")";
    }
}

