/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml;

import io.sitoolkit.cv.core.domain.classdef.ApiDocDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.uml.MessageDef;
import io.sitoolkit.cv.core.domain.uml.SequenceElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class LifeLineDef {
    private String objectName;
    private MessageDef entryMessage;
    private String sourceId;
    private List<SequenceElement> elements = new ArrayList<SequenceElement>();
    private ApiDocDef apiDoc;

    public Set<String> getAllSourceIds() {
        Set<String> tags = this.getLifeLinesRecursively().map(LifeLineDef::getSourceId).collect(Collectors.toSet());
        tags.add(this.sourceId);
        return tags;
    }

    public Stream<MessageDef> getMessagesRecursively() {
        return this.getElements().stream().flatMap(SequenceElement::getMessagesRecursively).filter(Objects::nonNull).distinct();
    }

    public Stream<LifeLineDef> getLifeLinesRecursively() {
        Stream<LifeLineDef> stream = this.getMessagesRecursively().map(MessageDef::getTarget);
        return Stream.concat(Stream.of(this), stream);
    }

    public Map<String, ApiDocDef> getApiDocsRecursively() {
        return this.getLifeLinesRecursively().collect(Collectors.toMap(l -> l.getEntryMessage().getRequestQualifiedSignature(), LifeLineDef::getApiDoc, (doc1, doc2) -> doc1));
    }

    public Stream<MethodDef> getSequenceMethodsRecursively() {
        return Stream.concat(Stream.of(this.entryMessage.getMethodDef()), this.getMessagesRecursively().map(MessageDef::getMethodDef));
    }

    @Generated
    public LifeLineDef() {
    }

    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @Generated
    public MessageDef getEntryMessage() {
        return this.entryMessage;
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public List<SequenceElement> getElements() {
        return this.elements;
    }

    @Generated
    public ApiDocDef getApiDoc() {
        return this.apiDoc;
    }

    @Generated
    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @Generated
    public void setEntryMessage(MessageDef entryMessage) {
        this.entryMessage = entryMessage;
    }

    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public void setElements(List<SequenceElement> elements) {
        this.elements = elements;
    }

    @Generated
    public void setApiDoc(ApiDocDef apiDoc) {
        this.apiDoc = apiDoc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LifeLineDef)) {
            return false;
        }
        LifeLineDef other = (LifeLineDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        List<SequenceElement> this$elements = this.getElements();
        List<SequenceElement> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        ApiDocDef this$apiDoc = this.getApiDoc();
        ApiDocDef other$apiDoc = other.getApiDoc();
        return !(this$apiDoc == null ? other$apiDoc != null : !((Object)this$apiDoc).equals(other$apiDoc));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LifeLineDef;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        List<SequenceElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        ApiDocDef $apiDoc = this.getApiDoc();
        result = result * 59 + ($apiDoc == null ? 43 : ((Object)$apiDoc).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LifeLineDef(objectName=" + this.getObjectName() + ", sourceId=" + this.getSourceId() + ", elements=" + this.getElements() + ", apiDoc=" + this.getApiDoc() + ")";
    }
}

