/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.uml;

import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.FieldDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.RelationDef;
import io.sitoolkit.cv.core.domain.classdef.TypeDef;
import io.sitoolkit.cv.core.domain.uml.ClassDiagram;
import io.sitoolkit.cv.core.domain.uml.LifeLineDef;
import io.sitoolkit.cv.core.domain.uml.RelationType;
import io.sitoolkit.cv.core.infra.config.CvConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDiagramProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassDiagramProcessor.class);
    @NonNull
    private CvConfig config;

    public ClassDiagram process(LifeLineDef lifeLine) {
        return this.process(lifeLine.getEntryMessage().getRequestQualifiedSignature(), lifeLine.getSequenceMethodsRecursively().collect(Collectors.toSet()));
    }

    public ClassDiagram process(String signature, Set<MethodDef> sequenceMethods) {
        Set<ClassDef> pickedClasses = this.pickClasses(sequenceMethods);
        Set<ClassDef> processedClasses = pickedClasses.stream().map(this::processClass).collect(Collectors.toSet());
        return this.process(signature + "(classDiagram)", processedClasses, relation -> pickedClasses.contains(relation.getOther()));
    }

    public ClassDiagram process(String id, Set<ClassDef> classes, Predicate<RelationDef> relationFilter) {
        Set<RelationDef> relations = classes.stream().flatMap(this::getRelations).filter(relationFilter).collect(Collectors.toSet());
        return ClassDiagram.builder().id(id).classes(classes).relations(relations).build();
    }

    private Stream<RelationDef> getRelations(ClassDef clazz) {
        Stream<RelationDef> instanceRels = clazz.getFields().stream().map(field -> this.getInstanceRelation(clazz, (FieldDef)field)).filter(Optional::isPresent).map(Optional::get);
        Stream classRels = this.getClassRelation(clazz).stream();
        Stream dependencies = clazz.getMethods().stream().flatMap(this::getDependencies);
        return Stream.of(instanceRels, classRels, dependencies).flatMap(Function.identity()).distinct();
    }

    private ClassDef processClass(ClassDef classDef) {
        if (!this.config.isShowAccessor()) {
            return this.removeAccessor(classDef);
        }
        return classDef;
    }

    private ClassDef removeAccessor(ClassDef classDef) {
        List<MethodDef> methods = classDef.getMethods().stream().filter(method -> !this.isMethodAccesor((MethodDef)method, classDef)).collect(Collectors.toList());
        ClassDef accessorRemoved = this.newInstance(classDef);
        accessorRemoved.setMethods(methods);
        return accessorRemoved;
    }

    private boolean isMethodAccesor(MethodDef method, ClassDef classDef) {
        return this.findFieldFromSetter(method).or(() -> this.findFieldFromNormalGetter(method)).or(() -> this.findFieldFromBooleanGetter(method)).filter(classDef.getFields()::contains).isPresent();
    }

    private Optional<FieldDef> findFieldFromNormalGetter(MethodDef method) {
        Optional<String> fieldName = this.findFieldName(method.getName(), "get");
        Optional<FieldDef> fieldType = fieldName.flatMap(f -> this.findFieldTypeFromNormalGetter(method));
        return fieldType.map(t -> this.createFieldDef((TypeDef)t, (String)fieldName.get()));
    }

    private Optional<FieldDef> findFieldFromBooleanGetter(MethodDef method) {
        Optional<String> fieldName = this.findFieldName(method.getName(), "is");
        Optional<FieldDef> fieldType = fieldName.flatMap(f -> this.findFieldTypeFromBooleanGetter(method));
        return fieldType.map(t -> this.createFieldDef((TypeDef)t, (String)fieldName.get()));
    }

    private Optional<FieldDef> findFieldFromSetter(MethodDef method) {
        Optional<String> fieldName = this.findFieldName(method.getName(), "set");
        Optional<FieldDef> fieldType = fieldName.flatMap(f -> this.findFieldTypeFromSetter(method));
        return fieldType.map(t -> this.createFieldDef((TypeDef)t, (String)fieldName.get()));
    }

    private Optional<TypeDef> findFieldTypeFromNormalGetter(MethodDef method) {
        List<TypeDef> paramTypes = method.getParamTypes();
        TypeDef returnType = method.getReturnType();
        if (paramTypes != null && paramTypes.isEmpty()) {
            return Optional.ofNullable(returnType);
        }
        return Optional.empty();
    }

    private Optional<TypeDef> findFieldTypeFromBooleanGetter(MethodDef method) {
        List<TypeDef> paramTypes = method.getParamTypes();
        TypeDef returnType = method.getReturnType();
        if (returnType != null && StringUtils.equals((CharSequence)returnType.getName(), (CharSequence)"boolean") && paramTypes != null && paramTypes.isEmpty()) {
            return Optional.ofNullable(returnType);
        }
        return Optional.empty();
    }

    private Optional<TypeDef> findFieldTypeFromSetter(MethodDef method) {
        List<TypeDef> paramTypes = method.getParamTypes();
        TypeDef returnType = method.getReturnType();
        if (returnType != null && StringUtils.equals((CharSequence)returnType.getName(), (CharSequence)"void") && paramTypes != null && paramTypes.size() == 1) {
            return Optional.ofNullable(paramTypes.get(0));
        }
        return Optional.empty();
    }

    private Optional<String> findFieldName(String methodName, String prefix) {
        if (!methodName.startsWith(prefix)) {
            return Optional.empty();
        }
        return Optional.ofNullable(StringUtils.uncapitalize((String)StringUtils.substringAfter((String)methodName, (String)prefix)));
    }

    private FieldDef createFieldDef(TypeDef type, String name) {
        FieldDef field = new FieldDef();
        TypeDef typeDef = new TypeDef();
        typeDef.setClassRef(type.getClassRef());
        typeDef.setName(type.getName());
        typeDef.setTypeParamList(type.getTypeParamList());
        typeDef.setVariable(null);
        field.setType(typeDef);
        field.setName(name);
        return field;
    }

    private Set<ClassDef> pickClasses(Set<MethodDef> sequenceMethods) {
        Set<ClassDef> paramClasses = sequenceMethods.stream().map(MethodDef::getParamTypes).flatMap(Collection::stream).flatMap(TypeDef::getTypeParamsRecursively).map(TypeDef::getClassRef).filter(Objects::nonNull).collect(Collectors.toSet());
        paramClasses.forEach(c -> log.debug("Param class picked :{}", (Object)c.getName()));
        Set<ClassDef> resultClasses = sequenceMethods.stream().map(MethodDef::getReturnType).flatMap(TypeDef::getTypeParamsRecursively).map(TypeDef::getClassRef).filter(Objects::nonNull).collect(Collectors.toSet());
        resultClasses.forEach(c -> log.debug("Result class picked :{}", (Object)c.getName()));
        Set<ClassDef> ret = Stream.of(paramClasses, resultClasses).flatMap(Collection::stream).flatMap(this::getFieldClassesRecursively).distinct().collect(Collectors.toSet());
        ret.forEach(c -> log.debug("Field class picked :{}", (Object)c.getName()));
        return ret;
    }

    Stream<ClassDef> getFieldClassesRecursively(ClassDef classDef) {
        return this.getFieldClassesRecursively(classDef, new HashSet<ClassDef>());
    }

    Stream<ClassDef> getFieldClassesRecursively(ClassDef classDef, Set<ClassDef> visited) {
        visited.add(classDef);
        return Stream.concat(Stream.of(classDef), classDef.getFields().stream().map(FieldDef::getType).flatMap(TypeDef::getTypeParamsRecursively).map(TypeDef::getClassRef).filter(Objects::nonNull).filter(field -> !visited.contains(field)).flatMap(field -> this.getFieldClassesRecursively((ClassDef)field, visited))).distinct();
    }

    private Stream<RelationDef> getDependencies(MethodDef method) {
        return method.getMethodCalls().stream().map(call -> this.getDependency(method, (MethodDef)call)).filter(rel -> !rel.getSelf().equals(rel.getOther()));
    }

    private RelationDef getDependency(MethodDef method, MethodDef call) {
        return RelationDef.builder().self(method.getClassDef()).other(call.getClassDef()).type(RelationType.DEPENDENCY).description("use").build();
    }

    private Optional<RelationDef> getInstanceRelation(ClassDef clazz, FieldDef field) {
        TypeWithCardinality c = this.getTypeWithCardinality(field.getType());
        RelationDef relation = RelationDef.builder().self(clazz).other(c.getType().getClassRef()).otherCardinality(c.getCardinality()).type(RelationType.OWNERSHIP).description("").build();
        return Optional.ofNullable(relation);
    }

    TypeWithCardinality getTypeWithCardinality(TypeDef type) {
        if (this.isCollection(type) && type.getTypeParamList().size() == 1) {
            return new TypeWithCardinality(type.getTypeParamList().get(0), "0..*");
        }
        if (this.isOptional(type) && type.getTypeParamList().size() == 1) {
            return new TypeWithCardinality(type.getTypeParamList().get(0), "0..1");
        }
        return new TypeWithCardinality(type, "1");
    }

    boolean isCollection(TypeDef type) {
        return Arrays.asList("java.util.Set", "java.util.List", "java.util.Collection").contains(type.getName());
    }

    boolean isOptional(TypeDef type) {
        return Arrays.asList("java.util.Optional").contains(type.getName());
    }

    private Set<RelationDef> getClassRelation(ClassDef clazz) {
        return Collections.emptySet();
    }

    ClassDef newInstance(ClassDef original) {
        ClassDef instance = new ClassDef();
        instance.setAnnotations(original.getAnnotations());
        instance.setFields(original.getFields());
        instance.setImplInterfaces(original.getImplInterfaces());
        instance.setKnownImplClasses(original.getKnownImplClasses());
        instance.setMethods(original.getMethods());
        instance.setName(original.getName());
        instance.setPkg(original.getPkg());
        instance.setSourceId(original.getSourceId());
        instance.setType(original.getType());
        return instance;
    }

    @Generated
    public ClassDiagramProcessor(@NonNull CvConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    final class TypeWithCardinality {
        private final TypeDef type;
        private final String cardinality;

        @Generated
        public TypeWithCardinality(TypeDef type, String cardinality) {
            this.type = type;
            this.cardinality = cardinality;
        }

        @Generated
        public TypeDef getType() {
            return this.type;
        }

        @Generated
        public String getCardinality() {
            return this.cardinality;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeWithCardinality)) {
                return false;
            }
            TypeWithCardinality other = (TypeWithCardinality)o;
            TypeDef this$type = this.getType();
            TypeDef other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$cardinality = this.getCardinality();
            String other$cardinality = other.getCardinality();
            return !(this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeDef $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            String $cardinality = this.getCardinality();
            result = result * 59 + ($cardinality == null ? 43 : $cardinality.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClassDiagramProcessor.TypeWithCardinality(type=" + this.getType() + ", cardinality=" + this.getCardinality() + ")";
        }
    }
}

