/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.report.functionmodel;

import io.sitoolkit.cv.core.domain.functionmodel.FunctionModel;
import io.sitoolkit.cv.core.domain.report.Report;
import io.sitoolkit.cv.core.domain.report.functionmodel.FunctionModelReportDetailDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionModelReportProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionModelReportProcessor.class);
    private static final String BASE_DIR = "functionmodel/";

    public List<Report<?>> process(List<FunctionModel> functionModels) {
        ArrayList reports = new ArrayList();
        DetailReportsAndPathMap reportsAndPathMap = this.buildAndGroupingDetailReports(functionModels);
        reports.addAll(reportsAndPathMap.getReports());
        reports.add(this.buildDetailPathMapReport(reportsAndPathMap.getPathMap()));
        return reports;
    }

    private DetailReportsAndPathMap buildAndGroupingDetailReports(List<FunctionModel> functionModels) {
        DetailReportsAndPathMap reportsAndPathMap = new DetailReportsAndPathMap();
        functionModels.stream().forEach(functionModel -> {
            try {
                String path = this.buildDetailPath((FunctionModel)functionModel);
                reportsAndPathMap.add(functionModel.getId(), path, this.buildDetail((FunctionModel)functionModel));
            }
            catch (Exception e) {
                log.warn("Exception when build report: functionId '{}'", (Object)functionModel.getId(), (Object)e);
            }
        });
        return reportsAndPathMap;
    }

    private String buildDetailPath(FunctionModel functionModel) {
        String dirName = functionModel.getPkg().replaceAll("\\.", "/");
        String fileName = functionModel.getClassName() + ".js";
        return BASE_DIR + dirName + "/" + fileName;
    }

    private FunctionModelReportDetailDef buildDetail(FunctionModel functionModel) {
        FunctionModelReportDetailDef detail = new FunctionModelReportDetailDef();
        functionModel.getAllDiagrams().stream().forEach(diagram -> {
            String data = new String(diagram.getData());
            detail.getDiagrams().put(diagram.getId(), data);
            detail.getApiDocs().putAll(diagram.getApiDocs());
        });
        return detail;
    }

    private Report<Map<String, String>> buildDetailPathMapReport(Map<String, String> detailPathMap) {
        return Report.builder().path("functionmodel/detail-path-map.js").content(detailPathMap).build();
    }

    class DetailMap {
        private Map<String, FunctionModelReportDetailDef> detailMap = new HashMap<String, FunctionModelReportDetailDef>();

        @Generated
        public DetailMap() {
        }

        @Generated
        public Map<String, FunctionModelReportDetailDef> getDetailMap() {
            return this.detailMap;
        }

        @Generated
        public void setDetailMap(Map<String, FunctionModelReportDetailDef> detailMap) {
            this.detailMap = detailMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DetailMap)) {
                return false;
            }
            DetailMap other = (DetailMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, FunctionModelReportDetailDef> this$detailMap = this.getDetailMap();
            Map<String, FunctionModelReportDetailDef> other$detailMap = other.getDetailMap();
            return !(this$detailMap == null ? other$detailMap != null : !((Object)this$detailMap).equals(other$detailMap));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DetailMap;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, FunctionModelReportDetailDef> $detailMap = this.getDetailMap();
            result = result * 59 + ($detailMap == null ? 43 : ((Object)$detailMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionModelReportProcessor.DetailMap(detailMap=" + this.getDetailMap() + ")";
        }
    }

    class DetailReportsAndPathMap {
        private Map<String, Report<DetailMap>> reportMap = new HashMap<String, Report<DetailMap>>();
        private Map<String, String> pathMap = new LinkedHashMap<String, String>();

        public void add(String functionId, String path, FunctionModelReportDetailDef detail) {
            this.pathMap.put(functionId, path);
            Report report = this.reportMap.computeIfAbsent(path, p -> Report.builder().path((String)p).content(new DetailMap()).build());
            ((DetailMap)report.getContent()).getDetailMap().put(functionId, detail);
        }

        public Collection<Report<DetailMap>> getReports() {
            return this.reportMap.values();
        }

        @Generated
        public DetailReportsAndPathMap() {
        }

        @Generated
        public Map<String, Report<DetailMap>> getReportMap() {
            return this.reportMap;
        }

        @Generated
        public Map<String, String> getPathMap() {
            return this.pathMap;
        }

        @Generated
        public void setReportMap(Map<String, Report<DetailMap>> reportMap) {
            this.reportMap = reportMap;
        }

        @Generated
        public void setPathMap(Map<String, String> pathMap) {
            this.pathMap = pathMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DetailReportsAndPathMap)) {
                return false;
            }
            DetailReportsAndPathMap other = (DetailReportsAndPathMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Report<DetailMap>> this$reportMap = this.getReportMap();
            Map<String, Report<DetailMap>> other$reportMap = other.getReportMap();
            if (this$reportMap == null ? other$reportMap != null : !((Object)this$reportMap).equals(other$reportMap)) {
                return false;
            }
            Map<String, String> this$pathMap = this.getPathMap();
            Map<String, String> other$pathMap = other.getPathMap();
            return !(this$pathMap == null ? other$pathMap != null : !((Object)this$pathMap).equals(other$pathMap));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DetailReportsAndPathMap;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Report<DetailMap>> $reportMap = this.getReportMap();
            result = result * 59 + ($reportMap == null ? 43 : ((Object)$reportMap).hashCode());
            Map<String, String> $pathMap = this.getPathMap();
            result = result * 59 + ($pathMap == null ? 43 : ((Object)$pathMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionModelReportProcessor.DetailReportsAndPathMap(reportMap=" + this.getReportMap() + ", pathMap=" + this.getPathMap() + ")";
        }
    }
}

