/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.report;

import io.sitoolkit.cv.core.domain.report.Report;
import io.sitoolkit.cv.core.infra.util.JsonUtils;
import io.sitoolkit.cv.core.infra.util.SitFileUtils;
import io.sitoolkit.cv.core.infra.util.SitResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportWriter.class);
    private static final String OUTPUT_DIR = "docs/designdocs";
    private static final String RESOURCE_NAME = "static";

    public void initDirectory(Path projectDir) {
        File outputDir = this.buildOutputDir(projectDir);
        try {
            FileUtils.deleteDirectory((File)outputDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        SitResourceUtils.copy(this.getClass(), RESOURCE_NAME, outputDir);
    }

    public void write(Path projectDir, List<Report<?>> reports) {
        Path outputDirPath = this.buildOutputDir(projectDir).toPath();
        this.writeReports(outputDirPath, reports);
        log.info("completed write to: {}", (Object)outputDirPath.toAbsolutePath().normalize());
    }

    void writeReports(Path outputDirPath, List<Report<?>> reports) {
        reports.stream().forEach(report -> {
            try {
                this.writeToFile(outputDirPath.resolve(report.getPath()).toFile(), this.report2javascript((Report<?>)report));
            }
            catch (Exception e) {
                log.warn("Exception writing report: file '{}'", (Object)report.getPath(), (Object)e);
            }
        });
    }

    String report2javascript(Report<?> report) {
        return "postMessage(" + JsonUtils.obj2str(report) + ", '*');";
    }

    void writeToFile(File file, String value) {
        try {
            FileUtils.writeStringToFile((File)file, (String)value, (Charset)SitFileUtils.DEFAULT_CHARSET);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    File buildOutputDir(Path projectDir) {
        return new File(projectDir.toString(), OUTPUT_DIR);
    }
}

