/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.maven;

import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.ProjectReader;
import io.sitoolkit.cv.core.domain.project.analyze.SqlLogProcessor;
import io.sitoolkit.cv.core.domain.project.maven.MavenProjectInfoListener;
import io.sitoolkit.cv.core.infra.config.CvConfig;
import io.sitoolkit.cv.core.infra.project.SitCvToolsManager;
import io.sitoolkit.util.buildtoolhelper.maven.MavenProject;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class MavenProjectReader
implements ProjectReader {
    @NonNull
    private SqlLogProcessor sqlLogProcessor;

    @Override
    public Optional<Project> read(Path projectDir) {
        MavenProject mvnPrj = MavenProject.load((Path)projectDir);
        if (!mvnPrj.available()) {
            return Optional.empty();
        }
        MavenProjectInfoListener listener = new MavenProjectInfoListener(projectDir);
        mvnPrj.mvnw(new String[]{"compile", "-X", "-B"}).stdout((StdoutListener)listener).execute();
        return Optional.of(listener.getProject());
    }

    @Override
    public boolean generateSqlLog(Project project, CvConfig sitCvConfig) {
        MavenProject mvnPrj = MavenProject.load((Path)project.getDir());
        if (!mvnPrj.available()) {
            return false;
        }
        Path agentJar = SitCvToolsManager.install(project.getWorkDir(), project.getJavaVersion());
        this.sqlLogProcessor.process("maven", sitCvConfig, agentJar, project, agentParam -> mvnPrj.mvnw(new String[]{"test", "-B", "-DargLine=" + agentParam}));
        return true;
    }

    @Generated
    public MavenProjectReader(@NonNull SqlLogProcessor sqlLogProcessor) {
        if (sqlLogProcessor == null) {
            throw new NullPointerException("sqlLogProcessor is marked non-null but is null");
        }
        this.sqlLogProcessor = sqlLogProcessor;
    }
}

