/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.lombok;

import io.sitoolkit.cv.core.domain.project.PreProcessor;
import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.infra.exception.ProcessExecutionException;
import io.sitoolkit.util.buildtoolhelper.process.ProcessCommand;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelombokProcessor
implements PreProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelombokProcessor.class);
    private Project project;
    private Path lombokJarPath;

    public static Optional<PreProcessor> of(Project project) {
        if (DelombokProcessor.isLombokUsed(project)) {
            return Optional.of(new DelombokProcessor(project));
        }
        return Optional.empty();
    }

    static boolean isLombokUsed(Project project) {
        Optional<Path> delombokClasspath = project.getClasspaths().stream().filter(classPath -> classPath.getFileName().toString().startsWith("lombok-")).findFirst();
        if (project.getBuildDir() == null) {
            log.debug("build directory not found in {}", (Object)project.getDir());
            return false;
        }
        if (delombokClasspath.isPresent()) {
            log.debug("Lombok dependency found in {} : {}", (Object)project.getDir(), (Object)delombokClasspath.get());
        } else {
            log.debug("Lombok dependency not found in {}", (Object)project.getDir());
        }
        return delombokClasspath.isPresent();
    }

    DelombokProcessor(Project project) {
        this.project = project;
        project.getClasspaths().stream().filter(classPath -> classPath.getFileName().toString().startsWith("lombok-")).findFirst().ifPresent(lombokJar -> {
            this.lombokJarPath = lombokJar;
        });
    }

    @Override
    public Path getPreProcessedPath(Path original) {
        Optional<Path> enclosingSrcDir = this.project.getSrcDirs().stream().filter(dir -> original.startsWith(original)).findFirst();
        if (enclosingSrcDir.isPresent()) {
            Path relativized = enclosingSrcDir.get().relativize(original);
            return this.getDelombokTargetDir().resolve(relativized.toString()).normalize();
        }
        throw new IllegalArgumentException(original.toAbsolutePath() + " is not_in source directory");
    }

    @Override
    public void execute() {
        this.project.getSrcDirs().forEach(this::executeDelombok);
    }

    void executeDelombok(Path srcDir) {
        String encoding = this.project.getSourceEncoding().name();
        String srcPath = srcDir.toFile().getAbsolutePath();
        String targetPath = this.getDelombokTargetDir().toFile().getAbsolutePath();
        String classPath = this.project.getClasspaths().stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        int exitCode = new ProcessCommand().command("java").args(new String[]{"-jar", this.lombokJarPath.toFile().getAbsolutePath(), "delombok", "-e", encoding, "-c", classPath, srcPath, "-d", targetPath}).stdout(arg_0 -> ((Logger)log).info(arg_0)).stderr(arg_0 -> ((Logger)log).warn(arg_0)).execute();
        if (exitCode != 0) {
            throw new ProcessExecutionException(exitCode);
        }
    }

    Path getDelombokTargetDir() {
        return this.project.getBuildDir().resolve("generated-sources/sit-cv/delombok");
    }
}

