/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.gradle;

import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.ProjectReader;
import io.sitoolkit.cv.core.domain.project.analyze.SqlLogProcessor;
import io.sitoolkit.cv.core.domain.project.gradle.GradleProjectInfoListener;
import io.sitoolkit.cv.core.infra.config.CvConfig;
import io.sitoolkit.cv.core.infra.project.SitCvToolsManager;
import io.sitoolkit.cv.core.infra.util.SitResourceUtils;
import io.sitoolkit.util.buildtoolhelper.gradle.GradleProject;
import io.sitoolkit.util.buildtoolhelper.process.ProcessCommand;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleProjectReader
implements ProjectReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GradleProjectReader.class);
    private static final String PROJECT_INFO_SCRIPT_NAME = "project-info.gradle";
    @NonNull
    private SqlLogProcessor sqlLogProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Project> read(Path projectDir) {
        GradleProject gradleProject = GradleProject.load((Path)projectDir);
        if (!gradleProject.available()) {
            return Optional.empty();
        }
        GradleProjectInfoListener listener = new GradleProjectInfoListener(projectDir);
        log.info("project: {} is a gradle project - finding depending jars... ", (Object)projectDir);
        Path initScript = projectDir.resolve(PROJECT_INFO_SCRIPT_NAME);
        SitResourceUtils.res2file(this, PROJECT_INFO_SCRIPT_NAME, initScript);
        try {
            gradleProject.gradlew(new String[]{"--no-daemon", "--init-script", initScript.toString(), "projectInfo"}).stdout((StdoutListener)listener).execute();
        }
        finally {
            try {
                Files.deleteIfExists(initScript);
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
        }
        return Optional.of(listener.getProject());
    }

    @Override
    public boolean generateSqlLog(Project project, CvConfig sitCvConfig) {
        GradleProject gradleProject = GradleProject.load((Path)project.getDir());
        if (!gradleProject.available()) {
            return false;
        }
        Path agentJar = SitCvToolsManager.install(project.getWorkDir(), project.getJavaVersion());
        this.sqlLogProcessor.process("gradle", sitCvConfig, agentJar, project, agentParam -> {
            ProcessCommand command = gradleProject.gradlew(new String[]{"--no-daemon", "--rerun-tasks", "test"});
            command.getEnv().put("JAVA_TOOL_OPTIONS", agentParam);
            return command;
        });
        return true;
    }

    @Generated
    public GradleProjectReader(@NonNull SqlLogProcessor sqlLogProcessor) {
        if (sqlLogProcessor == null) {
            throw new NullPointerException("sqlLogProcessor is marked non-null but is null");
        }
        this.sqlLogProcessor = sqlLogProcessor;
    }
}

