/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.analyze;

import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.analyze.SqlLogListener;
import io.sitoolkit.cv.core.infra.config.CvConfig;
import io.sitoolkit.cv.core.infra.config.FilterCondition;
import io.sitoolkit.cv.core.infra.config.FilterConditionGroup;
import io.sitoolkit.cv.core.infra.util.JsonUtils;
import io.sitoolkit.cv.core.infra.util.SitFileUtils;
import io.sitoolkit.util.buildtoolhelper.process.ProcessCommand;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SqlLogProcessor {
    public void process(String projectType, CvConfig config, Path agentJar, Project project, Function<String, ProcessCommand> commandBuilder) {
        SitFileUtils.createDirectories(project.getSqlLogPath().getParent());
        String javaAgentParameter = this.buildAgentParameter(agentJar, projectType, config.getRepositoryFilter());
        SqlLogListener sqlLogListener = new SqlLogListener(config.getSqlEnclosureFilter());
        ProcessCommand command = commandBuilder.apply(javaAgentParameter);
        command.stdout((StdoutListener)sqlLogListener).execute();
        JsonUtils.obj2file(sqlLogListener.getSqlLogs(), project.getSqlLogPath());
    }

    private String buildAgentParameter(Path agentJar, String projectType, FilterConditionGroup repositoryFilter) {
        HashMap<String, String> agentArgsMap = new HashMap<String, String>();
        this.putRepositoryFilter(agentArgsMap, repositoryFilter);
        agentArgsMap.put("projectType", projectType);
        agentArgsMap.put("repositoryMethodMarker", SqlLogListener.REPOSITORY_METHOD_MARKER);
        String agentArgs = agentArgsMap.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";", "=", ""));
        return "-javaagent:" + agentJar.toString() + agentArgs;
    }

    private void putRepositoryFilter(Map<String, String> agentArgsMap, FilterConditionGroup repositoryFilter) {
        this.putRepositoryFilter("include.", agentArgsMap, repositoryFilter.getInclude());
        this.putRepositoryFilter("exclude.", agentArgsMap, repositoryFilter.getExclude());
    }

    private void putRepositoryFilter(String prefix, Map<String, String> agentArgsMap, List<FilterCondition> conditions) {
        int index = 0;
        for (FilterCondition filterCondition : conditions) {
            String annotation = filterCondition.getAnnotation();
            String name = filterCondition.getName();
            agentArgsMap.put(prefix + "repositoryFilter" + ++index + ".annotation", StringUtils.defaultString((String)annotation));
            agentArgsMap.put(prefix + "repositoryFilter" + index + ".name", StringUtils.defaultString((String)name));
        }
    }
}

