/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project.analyze;

import io.sitoolkit.cv.core.domain.crud.SqlPerMethod;
import io.sitoolkit.cv.core.infra.config.EnclosureFilterCondition;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLogListener
implements StdoutListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlLogListener.class);
    public static String REPOSITORY_METHOD_MARKER = "[RepositoryMethod]";
    private static Pattern MARKER_PATTERN = Pattern.compile("^\\s*" + Pattern.quote(REPOSITORY_METHOD_MARKER) + ".*");
    private List<SqlPerMethod> sqlLogs = new ArrayList<SqlPerMethod>();
    private StringBuilder readingSqlLog = new StringBuilder();
    private String readingRepositoryMethod = "";
    private boolean sqlLogging = false;
    private EnclosureFilterCondition sqlEnclosureFilter;

    public SqlLogListener(EnclosureFilterCondition sqlEnclosureFilter) {
        this.sqlEnclosureFilter = sqlEnclosureFilter;
    }

    public void nextLine(String line) {
        String repositoryMethod;
        SqlPerMethod sqlLog;
        log.debug(line);
        boolean isMarkerLine = MARKER_PATTERN.matcher(line).matches();
        if (this.sqlLogging) {
            if (isMarkerLine || this.sqlEnclosureFilter.matchEnd(line)) {
                if (StringUtils.isNotEmpty((CharSequence)this.readingRepositoryMethod)) {
                    sqlLog = new SqlPerMethod(this.readingRepositoryMethod, this.readingSqlLog.toString());
                    log.info("{}", (Object)sqlLog);
                    this.sqlLogs.add(sqlLog);
                }
                this.sqlLogging = false;
                this.readingSqlLog = new StringBuilder();
                this.readingRepositoryMethod = "";
            } else {
                this.readingSqlLog.append(line);
                this.readingSqlLog.append("\n");
            }
        }
        if (isMarkerLine && !StringUtils.isEmpty((CharSequence)(repositoryMethod = StringUtils.substringAfter((String)line, (String)REPOSITORY_METHOD_MARKER)))) {
            this.readingRepositoryMethod = repositoryMethod;
        }
        if (!StringUtils.isEmpty((CharSequence)this.readingRepositoryMethod) && this.sqlEnclosureFilter.matchStart(line)) {
            this.sqlLogging = true;
        }
        if (this.sqlEnclosureFilter.matchRegex(line)) {
            sqlLog = new SqlPerMethod(this.readingRepositoryMethod, this.sqlEnclosureFilter.getMatchString(line));
            log.info("{}", (Object)sqlLog);
            this.sqlLogs.add(sqlLog);
        }
    }

    @Generated
    public List<SqlPerMethod> getSqlLogs() {
        return this.sqlLogs;
    }
}

