/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project;

import com.fasterxml.jackson.core.type.TypeReference;
import io.sitoolkit.cv.core.domain.crud.SqlPerMethod;
import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.ProjectReader;
import io.sitoolkit.cv.core.domain.project.lombok.DelombokProcessor;
import io.sitoolkit.cv.core.infra.config.CvConfig;
import io.sitoolkit.cv.core.infra.util.JsonUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectManager.class);
    @NonNull
    private List<ProjectReader> readers;
    @NonNull
    private CvConfig cvConfig;
    private Project currentProject;

    public void load(Path projectDir) {
        Optional<Project> project = this.readers.stream().map(reader -> reader.read(projectDir)).filter(Optional::isPresent).map(Optional::get).findFirst();
        this.currentProject = project.orElseThrow(() -> new IllegalArgumentException("Project is not supported " + projectDir));
        log.info("Loaded project: {}", (Object)this.currentProject);
        this.currentProject.getAllProjects().forEach(proj -> DelombokProcessor.of(proj).ifPresent(proj::setPreProcessor));
    }

    public Optional<List<SqlPerMethod>> getSqlLog() {
        return JsonUtils.file2obj(this.currentProject.getSqlLogPath(), new TypeReference<List<SqlPerMethod>>(){});
    }

    public void generateSqlLog() {
        this.readers.stream().filter(reader -> reader.generateSqlLog(this.currentProject, this.cvConfig)).findFirst();
    }

    @Generated
    public ProjectManager(@NonNull List<ProjectReader> readers, @NonNull CvConfig cvConfig) {
        if (readers == null) {
            throw new NullPointerException("readers is marked non-null but is null");
        }
        if (cvConfig == null) {
            throw new NullPointerException("cvConfig is marked non-null but is null");
        }
        this.readers = readers;
        this.cvConfig = cvConfig;
    }

    @NonNull
    @Generated
    public CvConfig getCvConfig() {
        return this.cvConfig;
    }

    @Generated
    public Project getCurrentProject() {
        return this.currentProject;
    }
}

