/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.project;

import io.sitoolkit.cv.core.domain.project.PreProcessor;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class Project {
    private static final String WORK_DIR = "sit-cv";
    private static final String SQL_LOG_FILE = "sit-cv-repository-vs-sql.json";
    private static final String CRUD_FILE = "crud.json";
    private Path dir;
    private Path buildDir;
    private String javaVersion;
    private Charset sourceEncoding = Charset.defaultCharset();
    private Set<Path> srcDirs = new HashSet<Path>();
    private Set<Path> classpaths = new HashSet<Path>();
    private Set<Project> subProjects = new HashSet<Project>();
    private PreProcessor preProcessor = PreProcessor.DO_NOTHING;

    public Project(Path dir) {
        this.dir = dir.toAbsolutePath().normalize();
    }

    public void executeAllPreProcess() {
        this.preProcessor.execute();
        this.subProjects.forEach(Project::executeAllPreProcess);
    }

    public Set<Project> getAllProjects() {
        return this.getAllProjectsStream().collect(Collectors.toSet());
    }

    public Set<Path> getAllClasspaths() {
        return this.getAllProjectsStream().flatMap(proj -> proj.classpaths.stream()).collect(Collectors.toSet());
    }

    public Set<Path> getAllSrcDirs() {
        return this.getAllProjectsStream().flatMap(proj -> proj.srcDirs.stream()).collect(Collectors.toSet());
    }

    public Set<Path> getAllPreProcessedDirs() {
        return this.getAllProjectsStream().flatMap(proj -> proj.getPreProcessedDirs().stream()).collect(Collectors.toSet());
    }

    public Optional<Path> findParseTarget(Path inputFile) {
        return this.findProjectFromSrc(inputFile).map(proj -> proj.getPreProcessor().getPreProcessedPath(inputFile));
    }

    public Path getSqlLogPath() {
        return this.getWorkDir().resolve(SQL_LOG_FILE);
    }

    public Path getCrudPath() {
        return this.getWorkDir().resolve(CRUD_FILE);
    }

    public Path getWorkDir() {
        return this.dir.resolve(this.buildDir).resolve(WORK_DIR);
    }

    public boolean existsWorkDir() {
        return this.getBuildDir() != null && this.getBuildDir().toFile().exists() && this.getWorkDir().toFile().exists();
    }

    Set<Path> getPreProcessedDirs() {
        return this.getSrcDirs().stream().map(srcDir -> this.preProcessor.getPreProcessedPath((Path)srcDir)).filter(srcDir -> srcDir.toFile().exists()).collect(Collectors.toSet());
    }

    Stream<Project> getAllProjectsStream() {
        return Stream.concat(Stream.of(this), this.subProjects.stream().flatMap(Project::getAllProjectsStream));
    }

    Optional<Project> findProjectFromSrc(Path inputFile) {
        if (this.srcDirs.stream().anyMatch(dir -> inputFile.startsWith((Path)dir))) {
            return Optional.of(this);
        }
        return this.subProjects.stream().map(subProject -> subProject.findProjectFromSrc(inputFile)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public String toString() {
        return "dir: " + this.dir + ", javaVersion:" + this.javaVersion + ", sourceEncoding: " + this.sourceEncoding + ", subProjects: " + this.subProjects.stream().map(Project::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Generated
    public Path getDir() {
        return this.dir;
    }

    @Generated
    public Path getBuildDir() {
        return this.buildDir;
    }

    @Generated
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Generated
    public Charset getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Generated
    public Set<Path> getSrcDirs() {
        return this.srcDirs;
    }

    @Generated
    public Set<Path> getClasspaths() {
        return this.classpaths;
    }

    @Generated
    public Set<Project> getSubProjects() {
        return this.subProjects;
    }

    @Generated
    public PreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Generated
    public void setBuildDir(Path buildDir) {
        this.buildDir = buildDir;
    }

    @Generated
    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    @Generated
    public void setSourceEncoding(Charset sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    @Generated
    public void setSrcDirs(Set<Path> srcDirs) {
        this.srcDirs = srcDirs;
    }

    @Generated
    public void setClasspaths(Set<Path> classpaths) {
        this.classpaths = classpaths;
    }

    @Generated
    public void setSubProjects(Set<Project> subProjects) {
        this.subProjects = subProjects;
    }

    @Generated
    public void setPreProcessor(PreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$dir = this.getDir();
        Path other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !((Object)this$dir).equals(other$dir)) {
            return false;
        }
        Path this$buildDir = this.getBuildDir();
        Path other$buildDir = other.getBuildDir();
        if (this$buildDir == null ? other$buildDir != null : !((Object)this$buildDir).equals(other$buildDir)) {
            return false;
        }
        String this$javaVersion = this.getJavaVersion();
        String other$javaVersion = other.getJavaVersion();
        if (this$javaVersion == null ? other$javaVersion != null : !this$javaVersion.equals(other$javaVersion)) {
            return false;
        }
        Charset this$sourceEncoding = this.getSourceEncoding();
        Charset other$sourceEncoding = other.getSourceEncoding();
        if (this$sourceEncoding == null ? other$sourceEncoding != null : !((Object)this$sourceEncoding).equals(other$sourceEncoding)) {
            return false;
        }
        Set<Path> this$srcDirs = this.getSrcDirs();
        Set<Path> other$srcDirs = other.getSrcDirs();
        if (this$srcDirs == null ? other$srcDirs != null : !((Object)this$srcDirs).equals(other$srcDirs)) {
            return false;
        }
        Set<Path> this$classpaths = this.getClasspaths();
        Set<Path> other$classpaths = other.getClasspaths();
        if (this$classpaths == null ? other$classpaths != null : !((Object)this$classpaths).equals(other$classpaths)) {
            return false;
        }
        Set<Project> this$subProjects = this.getSubProjects();
        Set<Project> other$subProjects = other.getSubProjects();
        if (this$subProjects == null ? other$subProjects != null : !((Object)this$subProjects).equals(other$subProjects)) {
            return false;
        }
        PreProcessor this$preProcessor = this.getPreProcessor();
        PreProcessor other$preProcessor = other.getPreProcessor();
        return !(this$preProcessor == null ? other$preProcessor != null : !this$preProcessor.equals(other$preProcessor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : ((Object)$dir).hashCode());
        Path $buildDir = this.getBuildDir();
        result = result * 59 + ($buildDir == null ? 43 : ((Object)$buildDir).hashCode());
        String $javaVersion = this.getJavaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : $javaVersion.hashCode());
        Charset $sourceEncoding = this.getSourceEncoding();
        result = result * 59 + ($sourceEncoding == null ? 43 : ((Object)$sourceEncoding).hashCode());
        Set<Path> $srcDirs = this.getSrcDirs();
        result = result * 59 + ($srcDirs == null ? 43 : ((Object)$srcDirs).hashCode());
        Set<Path> $classpaths = this.getClasspaths();
        result = result * 59 + ($classpaths == null ? 43 : ((Object)$classpaths).hashCode());
        Set<Project> $subProjects = this.getSubProjects();
        result = result * 59 + ($subProjects == null ? 43 : ((Object)$subProjects).hashCode());
        PreProcessor $preProcessor = this.getPreProcessor();
        result = result * 59 + ($preProcessor == null ? 43 : $preProcessor.hashCode());
        return result;
    }
}

