/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.designdoc;

import io.sitoolkit.cv.core.domain.menu.MenuItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DesignDocMenuBuilder {
    private static final Pattern QUALIFIED_METHOD_SIG_PATTERN = Pattern.compile("^(.*)\\.(.*?)(\\(.*)$");

    public List<MenuItem> build(List<String> functionIds) {
        return Arrays.asList(this.buildDataModelItem(), this.buildFunctionModelItem(functionIds));
    }

    private MenuItem buildDataModelItem() {
        MenuItem dataModelItem = MenuItem.builder().id("data-model").name("Data Model").build();
        dataModelItem.getChildren().add(MenuItem.builder().id("crud-matrix").name("CRUD Matrix").endpoint("/designdoc/data/crud").build());
        return dataModelItem;
    }

    private MenuItem buildFunctionModelItem(List<String> functionIds) {
        MenuItem functionModelNode = MenuItem.builder().id("function-model").name("Function Model").build();
        functionModelNode.getChildren().addAll(this.buildFunctionModelItems(functionIds));
        return functionModelNode;
    }

    private List<MenuItem> buildFunctionModelItems(List<String> functionIds) {
        ArrayList<MenuItem> rootItems = new ArrayList<MenuItem>();
        HashMap pathMenuItemMap = new HashMap();
        functionIds.stream().forEach(functionId -> {
            Matcher matcher = QUALIFIED_METHOD_SIG_PATTERN.matcher((CharSequence)functionId);
            matcher.matches();
            String fqcn = matcher.group(1);
            String methodName = matcher.group(2);
            MenuItem classItem = this.findItemWithCreatingParent(fqcn, pathMenuItemMap, rootItems);
            classItem.getChildren().add(this.buildMethodItem(methodName, (String)functionId));
        });
        return rootItems;
    }

    private MenuItem findItemWithCreatingParent(String currentPath, Map<String, MenuItem> pathMenuItemMap, List<MenuItem> rootItems) {
        MenuItem currentItem = pathMenuItemMap.get(currentPath);
        if (currentItem != null) {
            return currentItem;
        }
        boolean isRoot = !currentPath.contains(".");
        String currentItemName = isRoot ? currentPath : StringUtils.substringAfterLast((String)currentPath, (String)".");
        currentItem = MenuItem.builder().id(currentPath).name(currentItemName).build();
        pathMenuItemMap.put(currentPath, currentItem);
        if (isRoot) {
            rootItems.add(currentItem);
            return currentItem;
        }
        String parentPath = StringUtils.substringBeforeLast((String)currentPath, (String)".");
        MenuItem parentItem = this.findItemWithCreatingParent(parentPath, pathMenuItemMap, rootItems);
        parentItem.getChildren().add(currentItem);
        return currentItem;
    }

    private MenuItem buildMethodItem(String methodName, String functionId) {
        return MenuItem.builder().id(functionId + "." + methodName).name(methodName).endpoint("/designdoc/function/" + functionId).build();
    }
}

