/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.crud;

import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.crud.CrudFindResult;
import io.sitoolkit.cv.core.domain.crud.CrudFinder;
import io.sitoolkit.cv.core.domain.crud.CrudMatrix;
import io.sitoolkit.cv.core.domain.crud.CrudRow;
import io.sitoolkit.cv.core.domain.crud.CrudType;
import io.sitoolkit.cv.core.domain.crud.SqlPerMethod;
import io.sitoolkit.cv.core.domain.tabledef.TableDef;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrudProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrudProcessor.class);
    @NonNull
    CrudFinder crudFinder;

    public CrudMatrix buildMatrix(List<SqlPerMethod> sqlPerMethodList) {
        CrudMatrix matrix = new CrudMatrix();
        sqlPerMethodList.stream().forEach(sqlPerMethod -> {
            if (StringUtils.isEmpty((CharSequence)sqlPerMethod.getSqlText())) {
                return;
            }
            CrudFindResult result = this.crudFinder.findCrud(sqlPerMethod.getSqlText());
            if (result.isError()) {
                matrix.addError(sqlPerMethod.getRepositoryMethod(), sqlPerMethod.getSqlText(), result.getErrMsg());
            }
            result.getMap().keySet().stream().forEach(table -> result.getMap().get(table).stream().forEach(crud -> matrix.add(sqlPerMethod.getRepositoryMethod(), new TableDef((String)table), (CrudType)((Object)((Object)((Object)crud))), sqlPerMethod.getSqlText())));
        });
        return matrix;
    }

    public CrudMatrix adjustAxis(List<ClassDef> entryPoints, CrudMatrix repositoryMethodMatrix) {
        CrudMatrix result = new CrudMatrix();
        result.setErrorMap(repositoryMethodMatrix.getErrorMap());
        Stream entryPointMethods = entryPoints.stream().map(ClassDef::getMethods).flatMap(Collection::stream);
        entryPointMethods.forEach(entryPointMethod -> {
            Stream<MethodDef> implMethods = entryPointMethod.collectCalledMethodsRecursively();
            implMethods.forEach(methodCalledByEntryPoint -> {
                CrudRow repositoryMethodCrudRow = repositoryMethodMatrix.getCrudRowMap().get(methodCalledByEntryPoint.getQualifiedSignature().replaceAll(" ", ""));
                if (repositoryMethodCrudRow == null) {
                    return;
                }
                CrudRow entryPointMethodCrudRow = result.getCrudRowMap().computeIfAbsent(entryPointMethod.getQualifiedSignature(), key -> new CrudRow(entryPointMethod.getActionPath()));
                entryPointMethodCrudRow.merge(repositoryMethodCrudRow);
                result.getTableDefs().addAll(repositoryMethodCrudRow.getCellMap().keySet());
                log.debug("Mapped {} -> {} : {}", new Object[]{entryPointMethod.getQualifiedSignature(), methodCalledByEntryPoint.getQualifiedSignature(), entryPointMethodCrudRow.getCellMap()});
            });
        });
        return result;
    }

    @Generated
    public CrudProcessor(@NonNull CrudFinder crudFinder) {
        if (crudFinder == null) {
            throw new NullPointerException("crudFinder is marked non-null but is null");
        }
        this.crudFinder = crudFinder;
    }
}

