/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef.javaparser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserMethodDeclaration;
import io.sitoolkit.cv.core.domain.classdef.ApiDocDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDefReader;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepository;
import io.sitoolkit.cv.core.domain.classdef.ClassType;
import io.sitoolkit.cv.core.domain.classdef.FieldDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.javaparser.JavaParserFacadeBuilder;
import io.sitoolkit.cv.core.domain.classdef.javaparser.JavaParserUtils;
import io.sitoolkit.cv.core.domain.classdef.javaparser.StatementVisitor;
import io.sitoolkit.cv.core.domain.classdef.javaparser.TypeProcessor;
import io.sitoolkit.cv.core.domain.classdef.javaparser.VisitContext;
import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.ProjectManager;
import io.sitoolkit.cv.core.infra.config.CvConfig;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDefReaderJavaParserImpl
implements ClassDefReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassDefReaderJavaParserImpl.class);
    private JavaParserFacade jpf;
    private StatementVisitor statementVisitor;
    @NonNull
    private ClassDefRepository reposiotry;
    @NonNull
    private ProjectManager projectManager;
    @NonNull
    private CvConfig config;
    private static final String[] ACTION_ANNOTATION_NAMES = new String[]{"RequestMapping", "PostMapping", "GetMapping"};

    @Override
    public ClassDefReader readDir() {
        if (this.jpf == null) {
            throw new IllegalStateException("Reader has not been initialized yet");
        }
        Pattern p = Pattern.compile(this.config.getJavaFilePattern());
        this.projectManager.getCurrentProject().getAllPreProcessedDirs().stream().forEach(srcDir -> {
            try {
                List files = Files.walk(srcDir, new FileVisitOption[0]).filter(file -> p.matcher(file.toFile().getName()).matches()).collect(Collectors.toList());
                int readCount = 0;
                for (Path javaFile : files) {
                    this.readJava(javaFile).ifPresent(classDef -> this.reposiotry.save((ClassDef)classDef));
                    if (++readCount % 10 != 0 && readCount != files.size()) continue;
                    log.info("Processed java files : {} / {} in {}", new Object[]{readCount, files.size(), srcDir});
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        this.reposiotry.solveReferences();
        this.statementVisitor.clearCache();
        return this;
    }

    @Override
    public Optional<ClassDef> readJava(Path javaFile) {
        log.debug("Read java : {}", (Object)javaFile);
        try {
            CompilationUnit compilationUnit = JavaParser.parse((Path)javaFile);
            ClassDef classDef = new ClassDef();
            classDef.setSourceId(javaFile.toFile().getAbsolutePath());
            String typeName = (String)compilationUnit.getPrimaryTypeName().get();
            classDef.setName(typeName);
            classDef.setPkg(((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getNameAsString());
            compilationUnit.getClassByName(typeName).ifPresent(clazz -> {
                classDef.setType(ClassType.CLASS);
                classDef.setMethods(this.readMethodDefs((ClassOrInterfaceDeclaration)clazz));
                classDef.setFields(this.readFieldDefs((ClassOrInterfaceDeclaration)clazz));
                classDef.setImplInterfaces(this.readInterfaces((ClassOrInterfaceDeclaration)clazz));
                classDef.setAnnotations(this.readAnnotations((ClassOrInterfaceDeclaration)clazz));
            });
            compilationUnit.getInterfaceByName(typeName).ifPresent(interfaze -> {
                classDef.setType(ClassType.INTERFACE);
                classDef.setMethods(this.readMethodDefs((ClassOrInterfaceDeclaration)interfaze));
                classDef.setFields(this.readFieldDefs((ClassOrInterfaceDeclaration)interfaze));
                classDef.setAnnotations(this.readAnnotations((ClassOrInterfaceDeclaration)interfaze));
            });
            compilationUnit.getEnumByName(typeName).ifPresent(enumz -> {
                classDef.setType(ClassType.ENUM);
                classDef.setMethods(this.readMethodDefs((EnumDeclaration)enumz));
            });
            classDef.getMethods().stream().forEach(method -> method.setClassDef(classDef));
            log.debug("Read class : {}", (Object)classDef);
            return Optional.of(classDef);
        }
        catch (IOException e) {
            log.warn("IOException", (Throwable)e);
            return Optional.empty();
        }
    }

    private Set<String> readInterfaces(ClassOrInterfaceDeclaration typeDec) {
        Set<String> interfaces = new HashSet<String>();
        try {
            interfaces = this.jpf.getTypeDeclaration(typeDec).getAllAncestors().stream().map(ResolvedReferenceType::getTypeDeclaration).filter(ResolvedTypeDeclaration::isInterface).map(ResolvedTypeDeclaration::getQualifiedName).collect(Collectors.toSet());
            log.debug("{} implements interfaces: {}", (Object)typeDec.getNameAsString(), interfaces);
        }
        catch (Exception e) {
            log.debug("Unsolved : Ancestors of '{}', {}", (Object)typeDec.getName(), (Object)e);
        }
        return interfaces;
    }

    Set<String> readAnnotations(ClassOrInterfaceDeclaration typeDec) {
        Set<String> annotations = typeDec.getAnnotations().stream().map(NodeWithName::getNameAsString).collect(Collectors.toSet());
        log.debug("{} has annotations : {}", (Object)typeDec.getNameAsString(), annotations);
        return annotations;
    }

    List<MethodDef> readMethodDefs(ClassOrInterfaceDeclaration typeDec) {
        ArrayList<MethodDef> methodDefs = new ArrayList<MethodDef>();
        String classActionPath = this.getActionPath((NodeWithAnnotations<?>)typeDec);
        this.jpf.getTypeDeclaration(typeDec).getDeclaredMethods().forEach(declaredMethod -> {
            try {
                MethodDef methodDef = this.createMethodDef((ResolvedMethodDeclaration)declaredMethod);
                methodDefs.add(methodDef);
                if (!typeDec.isInterface()) {
                    typeDec.getMethods().stream().forEach(method -> {
                        if (this.equalMethods((ResolvedMethodDeclaration)declaredMethod, (MethodDeclaration)method)) {
                            method.accept((VoidVisitor)this.statementVisitor, (Object)VisitContext.of(methodDef));
                            methodDef.setActionPath(classActionPath + this.getActionPath((NodeWithAnnotations<?>)method));
                            methodDef.setAsync(JavaParserUtils.hasAnyAnnotation(method, this.config.getAsyncAnnotations()));
                        }
                    });
                }
                log.debug("Add method declaration : {}", (Object)methodDef);
            }
            catch (Exception e) {
                log.debug("Unsolved: '{}()' in '{}', {}", new Object[]{declaredMethod.getName(), typeDec.getName(), e});
            }
        });
        return methodDefs;
    }

    List<MethodDef> readMethodDefs(EnumDeclaration typeDec) {
        ArrayList<MethodDef> methodDefs = new ArrayList<MethodDef>();
        this.jpf.getTypeDeclaration((TypeDeclaration)typeDec).getDeclaredMethods().forEach(declaredMethod -> {
            try {
                MethodDef methodDef = this.createMethodDef((ResolvedMethodDeclaration)declaredMethod);
                methodDefs.add(methodDef);
                log.debug("Add method declaration : {}", (Object)methodDef);
            }
            catch (Exception e) {
                log.debug("Unsolved: '{}()' in '{}', {}", new Object[]{declaredMethod.getName(), typeDec.getName(), e});
            }
        });
        return methodDefs;
    }

    MethodDef createMethodDef(ResolvedMethodDeclaration declaredMethod) {
        JavaParserMethodDeclaration jpDeclaredMethod = (JavaParserMethodDeclaration)declaredMethod;
        MethodDef methodDef = new MethodDef();
        methodDef.setPublic(declaredMethod.accessSpecifier() == AccessSpecifier.PUBLIC);
        methodDef.setName(declaredMethod.getName());
        methodDef.setSignature(declaredMethod.getSignature());
        methodDef.setQualifiedSignature(declaredMethod.getQualifiedSignature());
        methodDef.setReturnType(TypeProcessor.createTypeDef(declaredMethod.getReturnType()));
        methodDef.setParamTypes(TypeProcessor.collectParamTypes(declaredMethod));
        methodDef.setExceptions(TypeProcessor.collectThrowTypeNames(declaredMethod));
        methodDef.setApiDoc(this.readApiDocDef(jpDeclaredMethod));
        return methodDef;
    }

    boolean equalMethods(ResolvedMethodDeclaration m1, MethodDeclaration m2) {
        if (!m1.getName().equals(m2.getNameAsString())) {
            return false;
        }
        if (m1.getNumberOfParams() != m2.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < m1.getNumberOfParams(); ++i) {
            ResolvedParameterDeclaration p1 = m1.getParam(i);
            Parameter p2 = m2.getParameter(i);
            if (!p1.getName().endsWith(p2.getNameAsString())) {
                return false;
            }
            if (this.equalTypes(p1.getType(), p2.getType())) continue;
            return false;
        }
        return true;
    }

    boolean equalTypes(ResolvedType t1, Type t2) {
        String str1 = t1.describe();
        String str2 = t2.asString();
        boolean result = StringUtils.equals((CharSequence)this.removePackageName(str1), (CharSequence)this.removePackageName(str2));
        log.debug("t1.describe={}, t2.asString={}, t1.equals(t2)={}", new Object[]{str1, str2, result});
        return result;
    }

    String removePackageName(String typeString) {
        return typeString.replaceAll("[^.,<>]+\\.", "");
    }

    String getActionPath(NodeWithAnnotations<?> nwa) {
        for (String annotationName : ACTION_ANNOTATION_NAMES) {
            Optional annotation = nwa.getAnnotationByName(annotationName);
            if (!annotation.isPresent()) continue;
            return this.retrive((AnnotationExpr)annotation.get());
        }
        return "";
    }

    String retrive(AnnotationExpr annotation) {
        StringBuilder actionPath = new StringBuilder();
        annotation.toNormalAnnotationExpr().ifPresent(nae -> nae.getPairs().forEach(mvp -> {
            if (StringUtils.equals((CharSequence)mvp.getNameAsString(), (CharSequence)"path")) {
                actionPath.append(this.adjust(mvp.getValue().toString()));
            }
        }));
        annotation.toSingleMemberAnnotationExpr().ifPresent(smae -> actionPath.append(this.adjust(smae.getMemberValue().toString())));
        return actionPath.toString();
    }

    String adjust(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        String adjust = StringUtils.strip((String)path, (String)"\"");
        if (adjust.startsWith("/")) {
            return adjust;
        }
        return "/" + adjust;
    }

    List<FieldDef> readFieldDefs(ClassOrInterfaceDeclaration typeDec) {
        return this.jpf.getTypeDeclaration(typeDec).getDeclaredFields().stream().map(declaredField -> {
            try {
                FieldDef fieldDef = new FieldDef();
                fieldDef.setName(declaredField.getName());
                ResolvedType type = declaredField.getType();
                fieldDef.setType(TypeProcessor.createTypeDef(type));
                return fieldDef;
            }
            catch (Exception e) {
                log.debug("Unsolved : '{}' in '{}', {}", new Object[]{declaredField.getName(), typeDec.getName(), e});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    ApiDocDef readApiDocDef(JavaParserMethodDeclaration declaredMethod) {
        String qualifiedClassName = declaredMethod.getPackageName() + "." + declaredMethod.getClassName();
        Optional javadoc = declaredMethod.getWrappedNode().getJavadoc();
        ArrayList<String> contents = new ArrayList<String>();
        if (javadoc.isPresent()) {
            contents.add(((Javadoc)javadoc.get()).getDescription().toText());
            List tagContents = ((Javadoc)javadoc.get()).getBlockTags().stream().map(JavadocBlockTag::toText).collect(Collectors.toList());
            contents.addAll(tagContents);
        } else {
            contents.add("No API Document.");
        }
        return ApiDocDef.builder().qualifiedClassName(qualifiedClassName).annotations(declaredMethod.getWrappedNode().getAnnotations().stream().map(Node::toString).collect(Collectors.toList())).methodDeclaration(declaredMethod.getWrappedNode().getDeclarationAsString()).contents(contents).build();
    }

    @Override
    public ClassDefReader init() {
        Project project = this.projectManager.getCurrentProject();
        this.jpf = JavaParserFacadeBuilder.build(project);
        this.statementVisitor = StatementVisitor.build(this.jpf);
        return this;
    }

    @Generated
    public ClassDefReaderJavaParserImpl(@NonNull ClassDefRepository reposiotry, @NonNull ProjectManager projectManager, @NonNull CvConfig config) {
        if (reposiotry == null) {
            throw new NullPointerException("reposiotry is marked non-null but is null");
        }
        if (projectManager == null) {
            throw new NullPointerException("projectManager is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.reposiotry = reposiotry;
        this.projectManager = projectManager;
        this.config = config;
    }
}

