/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef;

import io.sitoolkit.cv.core.domain.classdef.ApiDocDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.CvStatement;
import io.sitoolkit.cv.core.domain.classdef.MethodCallDef;
import io.sitoolkit.cv.core.domain.classdef.MethodCallStack;
import io.sitoolkit.cv.core.domain.classdef.StatementProcessor;
import io.sitoolkit.cv.core.domain.classdef.TypeDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodDef
implements CvStatement {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodDef.class);
    private String name;
    private String signature;
    private String qualifiedSignature;
    private boolean isPublic;
    private boolean isAsync;
    private String actionPath;
    private ClassDef classDef;
    private List<TypeDef> paramTypes;
    private Set<String> exceptions;
    private TypeDef returnType;
    private Set<MethodCallDef> methodCalls = new HashSet<MethodCallDef>();
    private List<CvStatement> statements = new ArrayList<CvStatement>();
    private ApiDocDef apiDoc;

    @Override
    public <T, C> Optional<T> process(StatementProcessor<T, C> processor) {
        return processor.process(this);
    }

    @Override
    public <T, C> Optional<T> process(StatementProcessor<T, C> processor, C context) {
        return processor.process(this, context);
    }

    public MethodDef findImplementation() {
        ClassDef clazz = this.getClassDef();
        if (clazz == null) {
            return this;
        }
        ClassDef impleClass = clazz.findImplementation();
        Optional<MethodDef> methodImpl = impleClass.findMethodBySignature(this.getSignature());
        if (methodImpl.isPresent()) {
            return methodImpl.get();
        }
        return this;
    }

    public Stream<MethodDef> collectCalledMethodsRecursively() {
        return Stream.concat(Stream.of(this), this.collectCalledMethodsRecursively(this.getMethodCalls(), MethodCallStack.getBlank()));
    }

    private Stream<MethodDef> collectCalledMethodsRecursively(MethodCallDef method, MethodCallStack callStack) {
        MethodDef methodImpl = method.findImplementation();
        if (callStack.contains(methodImpl)) {
            log.debug("method: {} is called recursively", (Object)methodImpl.getQualifiedSignature());
            return Stream.empty();
        }
        MethodCallStack pushedStack = callStack.push(methodImpl);
        return Stream.concat(Stream.of(methodImpl), this.collectCalledMethodsRecursively(methodImpl.getMethodCalls(), pushedStack));
    }

    private Stream<MethodDef> collectCalledMethodsRecursively(Set<MethodCallDef> methodCalls, MethodCallStack callStack) {
        return methodCalls.stream().flatMap(method -> this.collectCalledMethodsRecursively((MethodCallDef)method, callStack));
    }

    @Generated
    public MethodDef() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public String getQualifiedSignature() {
        return this.qualifiedSignature;
    }

    @Generated
    public boolean isPublic() {
        return this.isPublic;
    }

    @Generated
    public boolean isAsync() {
        return this.isAsync;
    }

    @Generated
    public String getActionPath() {
        return this.actionPath;
    }

    @Generated
    public ClassDef getClassDef() {
        return this.classDef;
    }

    @Generated
    public List<TypeDef> getParamTypes() {
        return this.paramTypes;
    }

    @Generated
    public Set<String> getExceptions() {
        return this.exceptions;
    }

    @Generated
    public TypeDef getReturnType() {
        return this.returnType;
    }

    @Generated
    public Set<MethodCallDef> getMethodCalls() {
        return this.methodCalls;
    }

    @Generated
    public List<CvStatement> getStatements() {
        return this.statements;
    }

    @Generated
    public ApiDocDef getApiDoc() {
        return this.apiDoc;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Generated
    public void setQualifiedSignature(String qualifiedSignature) {
        this.qualifiedSignature = qualifiedSignature;
    }

    @Generated
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Generated
    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    @Generated
    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    @Generated
    public void setClassDef(ClassDef classDef) {
        this.classDef = classDef;
    }

    @Generated
    public void setParamTypes(List<TypeDef> paramTypes) {
        this.paramTypes = paramTypes;
    }

    @Generated
    public void setExceptions(Set<String> exceptions) {
        this.exceptions = exceptions;
    }

    @Generated
    public void setReturnType(TypeDef returnType) {
        this.returnType = returnType;
    }

    @Generated
    public void setMethodCalls(Set<MethodCallDef> methodCalls) {
        this.methodCalls = methodCalls;
    }

    @Generated
    public void setStatements(List<CvStatement> statements) {
        this.statements = statements;
    }

    @Generated
    public void setApiDoc(ApiDocDef apiDoc) {
        this.apiDoc = apiDoc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodDef)) {
            return false;
        }
        MethodDef other = (MethodDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$qualifiedSignature = this.getQualifiedSignature();
        String other$qualifiedSignature = other.getQualifiedSignature();
        return !(this$qualifiedSignature == null ? other$qualifiedSignature != null : !this$qualifiedSignature.equals(other$qualifiedSignature));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MethodDef;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $qualifiedSignature = this.getQualifiedSignature();
        result = result * 59 + ($qualifiedSignature == null ? 43 : $qualifiedSignature.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MethodDef(name=" + this.getName() + ", signature=" + this.getSignature() + ", qualifiedSignature=" + this.getQualifiedSignature() + ", isPublic=" + this.isPublic() + ", isAsync=" + this.isAsync() + ", actionPath=" + this.getActionPath() + ", paramTypes=" + this.getParamTypes() + ", exceptions=" + this.getExceptions() + ", returnType=" + this.getReturnType() + ", apiDoc=" + this.getApiDoc() + ")";
    }
}

