/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef;

import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDefFilter;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepository;
import io.sitoolkit.cv.core.domain.classdef.FieldDef;
import io.sitoolkit.cv.core.domain.classdef.MethodCallDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.classdef.TypeDef;
import io.sitoolkit.cv.core.infra.config.CvConfig;
import io.sitoolkit.cv.core.infra.config.FilterConditionGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDefRepositoryMemImpl
implements ClassDefRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassDefRepositoryMemImpl.class);
    private Map<String, ClassDef> classDefMap = new HashMap<String, ClassDef>();
    private Map<String, MethodDef> methodDefMap = new HashMap<String, MethodDef>();
    @NonNull
    private CvConfig config;

    @Override
    public void save(ClassDef classDef) {
        this.classDefMap.put(classDef.getFullyQualifiedName(), classDef);
        classDef.getMethods().stream().forEach(methodDef -> this.methodDefMap.put(methodDef.getQualifiedSignature(), (MethodDef)methodDef));
    }

    @Override
    public void remove(String sourceId) {
        Optional<ClassDef> removingClass = this.classDefMap.values().stream().filter(clazz -> StringUtils.equals((CharSequence)clazz.getSourceId(), (CharSequence)sourceId)).findFirst();
        removingClass.ifPresent(classDef -> {
            this.classDefMap.remove(classDef.getFullyQualifiedName());
            classDef.getMethods().stream().forEach(methodDef -> this.methodDefMap.remove(methodDef.getQualifiedSignature()));
        });
    }

    @Override
    public Collection<ClassDef> getAllClassDefs() {
        return Collections.unmodifiableCollection(this.classDefMap.values());
    }

    @Override
    public int countClassDefs() {
        return this.classDefMap.size();
    }

    @Override
    public void solveReferences() {
        this.solveMethodCalls();
        this.solveClassRefs();
    }

    public void solveMethodCalls() {
        this.classDefMap.values().stream().forEach(this::solveMethodCalls);
    }

    public void solveMethodCalls(ClassDef classDef) {
        classDef.getMethods().stream().forEach(methodDef -> {
            this.solveMethodType((MethodDef)methodDef);
            methodDef.getMethodCalls().stream().forEach(this::solveMethodCall);
        });
    }

    private void solveMethodCall(MethodCallDef methodCall) {
        MethodDef method;
        this.solveMethodType(methodCall);
        this.solveMethodCallClass(methodCall);
        if (methodCall.getStatements().isEmpty() && (method = this.methodDefMap.get(methodCall.getQualifiedSignature())) != null) {
            methodCall.setStatements(method.getStatements());
            methodCall.setMethodCalls(method.getMethodCalls());
        }
    }

    private void solveMethodType(MethodDef methodDef) {
        methodDef.getParamTypes().forEach(this::solveClassRef);
        this.solveClassRef(methodDef.getReturnType());
    }

    private void solveClassRef(TypeDef type) {
        type.getTypeParamsRecursively().forEach(t -> {
            ClassDef refType = this.classDefMap.get(t.getName());
            if (refType != null) {
                t.setClassRef(refType);
            }
        });
    }

    private void solveMethodCallClass(MethodCallDef calledMethod) {
        ClassDef calledMethodClass = this.classDefMap.get(calledMethod.getPackageName() + "." + calledMethod.getClassName());
        calledMethod.setClassDef(calledMethodClass);
    }

    @Override
    public List<String> getEntryPoints() {
        return this.getFilteredEntryPointClasses().map(ClassDef::getMethods).flatMap(Collection::stream).filter(MethodDef::isPublic).map(MethodDef::getQualifiedSignature).sorted().collect(Collectors.toList());
    }

    @Override
    public List<ClassDef> getAllEntryPointClasses() {
        return this.getFilteredEntryPointClasses().collect(Collectors.toList());
    }

    private Stream<ClassDef> getFilteredEntryPointClasses() {
        FilterConditionGroup entryPointFilter = this.config.getEntryPointFilter();
        return this.getAllClassDefs().stream().filter(classDef -> ClassDefFilter.match(classDef, entryPointFilter));
    }

    @Override
    public MethodDef findMethodByQualifiedSignature(String qualifiedSignature) {
        return this.methodDefMap.get(qualifiedSignature);
    }

    @Override
    public ClassDef findClassByQualifiedName(String qualifiedName) {
        return this.classDefMap.get(qualifiedName);
    }

    public void solveClassRefs() {
        this.classDefMap.values().stream().forEach(this::solveClassRefs);
    }

    void solveClassRefs(ClassDef clazz) {
        log.debug("solving class {}", (Object)clazz.getName());
        clazz.getFields().stream().map(FieldDef::getType).forEach(this::solveClassRef);
        if (clazz.isClass()) {
            clazz.getImplInterfaces().stream().forEach(ifName -> {
                ClassDef refType = this.classDefMap.get(ifName);
                if (refType != null) {
                    refType.getKnownImplClasses().remove(clazz);
                    refType.getKnownImplClasses().add(clazz);
                    log.debug("{} is Known implementation of {}", (Object)clazz.getName(), ifName);
                }
            });
        }
    }

    @Generated
    public ClassDefRepositoryMemImpl(@NonNull CvConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }
}

