/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.domain.classdef;

import io.sitoolkit.cv.core.domain.classdef.ClassType;
import io.sitoolkit.cv.core.domain.classdef.FieldDef;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDef {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassDef.class);
    private String pkg;
    private String name;
    private String sourceId;
    private ClassType type;
    private List<MethodDef> methods = new ArrayList<MethodDef>();
    private List<FieldDef> fields = new ArrayList<FieldDef>();
    private Set<String> implInterfaces = new HashSet<String>();
    private Set<ClassDef> knownImplClasses = new HashSet<ClassDef>();
    private Set<String> annotations = new HashSet<String>();

    public boolean isInterface() {
        return ClassType.INTERFACE.equals((Object)this.type);
    }

    public boolean isClass() {
        return ClassType.CLASS.equals((Object)this.type);
    }

    public String getFullyQualifiedName() {
        return this.pkg + "." + this.name;
    }

    public ClassDef findImplementation() {
        if (!this.isInterface()) {
            return this;
        }
        Set<ClassDef> knownImplClasses = this.getKnownImplClasses();
        log.debug("Interface {} has KnownImplements : {}", (Object)this.getName(), knownImplClasses);
        if (knownImplClasses.size() == 1) {
            ClassDef onlyImpl = knownImplClasses.iterator().next();
            log.debug("{}'s the only known impl found : {} ", (Object)this.getName(), (Object)onlyImpl.getName());
            return onlyImpl;
        }
        return this;
    }

    public Optional<MethodDef> findMethodBySignature(String signature) {
        log.debug("Finding '{}' from '{}'", (Object)signature, (Object)this.getName());
        Optional<MethodDef> foundMethod = this.getMethods().stream().filter(m -> StringUtils.equals((CharSequence)signature, (CharSequence)m.getSignature())).findFirst();
        if (foundMethod.isPresent()) {
            log.debug("Method found : {}", (Object)foundMethod.get().getQualifiedSignature());
        } else {
            log.debug("'{}' not found from '{}'", (Object)signature, (Object)this.getName());
        }
        return foundMethod;
    }

    @Generated
    public ClassDef() {
    }

    @Generated
    public String getPkg() {
        return this.pkg;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public ClassType getType() {
        return this.type;
    }

    @Generated
    public List<MethodDef> getMethods() {
        return this.methods;
    }

    @Generated
    public List<FieldDef> getFields() {
        return this.fields;
    }

    @Generated
    public Set<String> getImplInterfaces() {
        return this.implInterfaces;
    }

    @Generated
    public Set<ClassDef> getKnownImplClasses() {
        return this.knownImplClasses;
    }

    @Generated
    public Set<String> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public void setType(ClassType type) {
        this.type = type;
    }

    @Generated
    public void setMethods(List<MethodDef> methods) {
        this.methods = methods;
    }

    @Generated
    public void setFields(List<FieldDef> fields) {
        this.fields = fields;
    }

    @Generated
    public void setImplInterfaces(Set<String> implInterfaces) {
        this.implInterfaces = implInterfaces;
    }

    @Generated
    public void setKnownImplClasses(Set<ClassDef> knownImplClasses) {
        this.knownImplClasses = knownImplClasses;
    }

    @Generated
    public void setAnnotations(Set<String> annotations) {
        this.annotations = annotations;
    }

    @Generated
    public String toString() {
        return "ClassDef(pkg=" + this.getPkg() + ", name=" + this.getName() + ", sourceId=" + this.getSourceId() + ", type=" + this.getType() + ", methods=" + this.getMethods() + ", fields=" + this.getFields() + ", implInterfaces=" + this.getImplInterfaces() + ", knownImplClasses=" + this.getKnownImplClasses() + ", annotations=" + this.getAnnotations() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDef)) {
            return false;
        }
        ClassDef other = (ClassDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pkg = this.getPkg();
        String other$pkg = other.getPkg();
        if (this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassDef;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pkg = this.getPkg();
        result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

