/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.app.functionmodel;

import io.sitoolkit.cv.core.app.functionmodel.AnalysisResult;
import io.sitoolkit.cv.core.domain.classdef.ClassDef;
import io.sitoolkit.cv.core.domain.classdef.ClassDefReader;
import io.sitoolkit.cv.core.domain.classdef.ClassDefRepository;
import io.sitoolkit.cv.core.domain.classdef.MethodDef;
import io.sitoolkit.cv.core.domain.functionmodel.Diagram;
import io.sitoolkit.cv.core.domain.functionmodel.FunctionModel;
import io.sitoolkit.cv.core.domain.project.Project;
import io.sitoolkit.cv.core.domain.project.ProjectManager;
import io.sitoolkit.cv.core.domain.uml.ClassDiagram;
import io.sitoolkit.cv.core.domain.uml.ClassDiagramProcessor;
import io.sitoolkit.cv.core.domain.uml.DiagramModel;
import io.sitoolkit.cv.core.domain.uml.DiagramWriter;
import io.sitoolkit.cv.core.domain.uml.LifeLineDef;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagram;
import io.sitoolkit.cv.core.domain.uml.SequenceDiagramProcessor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionModelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionModelService.class);
    @NonNull
    private ClassDefReader classDefReader;
    @NonNull
    private SequenceDiagramProcessor sequenceProcessor;
    @NonNull
    private ClassDiagramProcessor classProcessor;
    @NonNull
    private DiagramWriter<SequenceDiagram> sequenceWriter;
    @NonNull
    private DiagramWriter<ClassDiagram> classWriter;
    @NonNull
    private ClassDefRepository classDefRepository;
    @NonNull
    private ProjectManager projectManager;
    private Map<String, Set<String>> entryPointMap = new HashMap<String, Set<String>>();

    public void analyze() {
        StopWatch stopWatch = StopWatch.createStarted();
        this.projectManager.getCurrentProject().executeAllPreProcess();
        this.classDefReader.init().readDir();
        log.info("Analysis finished in {}", (Object)stopWatch);
    }

    public AnalysisResult analyze(Set<Path> srcFiles) {
        AnalysisResult result = new AnalysisResult();
        HashSet<String> entryPoitsBefore = new HashSet<String>(this.classDefRepository.getEntryPoints());
        result.setEffectedSourceIds(this.readSources(srcFiles));
        HashSet<String> entryPoitsAfter = new HashSet<String>(this.classDefRepository.getEntryPoints());
        result.setEntryPointModified(!entryPoitsBefore.equals(entryPoitsAfter));
        return result;
    }

    public synchronized Set<String> getEntryPoints() {
        return this.entryPointMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toSet());
    }

    private Stream<String> readSources(Collection<Path> sourcePaths) {
        Project currentProject = this.projectManager.getCurrentProject();
        currentProject.executeAllPreProcess();
        this.classDefReader.init();
        Set<ClassDef> readDefs = sourcePaths.stream().filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(Files::isReadable).map(currentProject::findParseTarget).filter(Optional::isPresent).map(Optional::get).map(this.classDefReader::readJava).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        readDefs.forEach(this.classDefRepository::save);
        readDefs.forEach(clazz -> log.debug("Read {}", clazz));
        Set<String> deletedIds = sourcePaths.stream().filter(s -> !Files.isDirectory(s, new LinkOption[0])).map(Path::toString).filter(sId -> !readDefs.stream().anyMatch(clazz -> StringUtils.equals((CharSequence)sId, (CharSequence)clazz.getSourceId()))).collect(Collectors.toSet());
        deletedIds.forEach(clazz -> log.debug("Remove {}", clazz));
        deletedIds.forEach(this.classDefRepository::remove);
        this.classDefRepository.solveReferences();
        return readDefs.stream().map(ClassDef::getSourceId).map(this.entryPointMap::get).filter(Objects::nonNull).flatMap(Collection::stream).distinct();
    }

    public List<String> getAllIds() {
        return this.classDefRepository.getEntryPoints();
    }

    public FunctionModel get(String functionId) {
        log.info("Build diagram for {}", (Object)functionId);
        MethodDef entryPoint = this.classDefRepository.findMethodByQualifiedSignature(functionId);
        LifeLineDef lifeLine = this.sequenceProcessor.process(entryPoint.getClassDef(), entryPoint);
        SequenceDiagram sequenceModel = SequenceDiagram.builder().entryLifeLine(lifeLine).build();
        ClassDiagram classModel = this.classProcessor.process(lifeLine);
        Stream allSourceIds = Stream.of(sequenceModel, classModel).map(DiagramModel::getAllSourceIds).flatMap(Collection::stream).distinct();
        allSourceIds.forEach(sourceId -> {
            Set entryPoints = this.entryPointMap.computeIfAbsent((String)sourceId, key -> new HashSet());
            entryPoints.add(entryPoint.getQualifiedSignature());
        });
        Diagram sequenceDiagram = this.sequenceWriter.write(sequenceModel);
        Diagram classDiagram = this.classWriter.write(classModel);
        FunctionModel model = new FunctionModel();
        model.setId(functionId);
        model.setPkg(entryPoint.getClassDef().getPkg());
        model.setClassName(entryPoint.getClassDef().getName());
        model.add(sequenceDiagram);
        model.add(classDiagram);
        return model;
    }

    public List<FunctionModel> getAll() {
        List<FunctionModel> functionModels = this.getAllIds().stream().map(functionId -> {
            try {
                return this.get((String)functionId);
            }
            catch (Exception e) {
                log.warn("Exception when create diagram: functionId '{}'", functionId, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return functionModels;
    }

    public List<ClassDef> getAllEntryPointClasses() {
        return this.classDefRepository.getAllEntryPointClasses();
    }

    @Generated
    public FunctionModelService(@NonNull ClassDefReader classDefReader, @NonNull SequenceDiagramProcessor sequenceProcessor, @NonNull ClassDiagramProcessor classProcessor, @NonNull DiagramWriter<SequenceDiagram> sequenceWriter, @NonNull DiagramWriter<ClassDiagram> classWriter, @NonNull ClassDefRepository classDefRepository, @NonNull ProjectManager projectManager) {
        if (classDefReader == null) {
            throw new NullPointerException("classDefReader is marked non-null but is null");
        }
        if (sequenceProcessor == null) {
            throw new NullPointerException("sequenceProcessor is marked non-null but is null");
        }
        if (classProcessor == null) {
            throw new NullPointerException("classProcessor is marked non-null but is null");
        }
        if (sequenceWriter == null) {
            throw new NullPointerException("sequenceWriter is marked non-null but is null");
        }
        if (classWriter == null) {
            throw new NullPointerException("classWriter is marked non-null but is null");
        }
        if (classDefRepository == null) {
            throw new NullPointerException("classDefRepository is marked non-null but is null");
        }
        if (projectManager == null) {
            throw new NullPointerException("projectManager is marked non-null but is null");
        }
        this.classDefReader = classDefReader;
        this.sequenceProcessor = sequenceProcessor;
        this.classProcessor = classProcessor;
        this.sequenceWriter = sequenceWriter;
        this.classWriter = classWriter;
        this.classDefRepository = classDefRepository;
        this.projectManager = projectManager;
    }
}

