/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.watcher;

import io.sitoolkit.cv.core.infra.watcher.InputSourceEventListener;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputSourceWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputSourceWatcher.class);
    private boolean isContinue = false;
    Set<String> waitingSources = new HashSet<String>();
    Instant lastSourceChangedTime;
    final long RELOAD_WAIT_TIME_MILLIS = 300L;

    public void watch(String inputSource) {
        if (!this.isContinue()) {
            return;
        }
        this.watchInputSource(inputSource);
    }

    public void start(InputSourceEventListener inputSourceEventListener) {
        if (!this.isContinue()) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(() -> {
            while (this.isContinue()) {
                Set<String> inputSources = this.watching();
                this.putInputSources(inputSources);
                log.info("Detected input source change {}", inputSources);
            }
        });
        executor.execute(() -> {
            while (this.isContinue()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(300L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                this.getReadyToRegenerateSources().ifPresent(sources -> {
                    try {
                        inputSourceEventListener.onChange((Collection<String>)sources);
                    }
                    catch (Exception e) {
                        log.error("Exception in the process of file change event", (Throwable)e);
                    }
                });
            }
        });
    }

    public boolean isContinue() {
        return this.isContinue;
    }

    public void setContinue(boolean isContinue) {
        this.isContinue = isContinue;
    }

    private synchronized void putInputSources(Collection<String> inputSources) {
        this.waitingSources.addAll(inputSources);
        this.lastSourceChangedTime = Instant.now();
    }

    private synchronized Optional<Set<String>> getReadyToRegenerateSources() {
        if (!this.waitingSources.isEmpty() && Instant.now().isAfter(this.lastSourceChangedTime.plusMillis(300L))) {
            HashSet<String> result = new HashSet<String>(this.waitingSources);
            this.waitingSources.clear();
            return Optional.of(result);
        }
        return Optional.empty();
    }

    protected abstract void watchInputSource(String var1);

    protected abstract Set<String> watching();

    protected abstract void end(InputSourceEventListener var1);
}

