/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.watcher;

import io.sitoolkit.cv.core.infra.watcher.InputSourceEventListener;
import io.sitoolkit.cv.core.infra.watcher.InputSourceWatcher;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInputSourceWatcher
extends InputSourceWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileInputSourceWatcher.class);
    private WatchService watcher;
    private final Set<String> watchingDirSet = new HashSet<String>();
    private final Map<String, InputSource> watchingFileMap = new HashMap<String, InputSource>();
    private final Map<WatchKey, Path> pathMap = new HashMap<WatchKey, Path>();

    @Override
    public void watchInputSource(String inputSource) {
        Path path = Paths.get(inputSource, new String[0]).normalize().toAbsolutePath();
        if (!path.toFile().exists()) {
            log.warn("File not found {}", (Object)inputSource);
            return;
        }
        log.info("Start to watch {}", (Object)path);
        if (path.toFile().isFile()) {
            this.watchFile(path);
        } else {
            try {
                Files.walk(path, new FileVisitOption[0]).forEach(childPath -> {
                    if (childPath.toFile().isFile()) {
                        this.watchFile((Path)childPath);
                    } else {
                        this.watchDir((Path)childPath);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void watchFile(Path file) {
        String fileStr = file.toString();
        if (this.watchingFileMap.containsKey(fileStr)) {
            return;
        }
        log.debug("Start to watch file {}", (Object)file);
        this.watchingFileMap.put(fileStr, new InputSource(fileStr, file.toFile().lastModified()));
        Path parentDir = this.toParentDir(file);
        this.registWatcher(parentDir);
    }

    private void watchDir(Path dir) {
        String dirStr = dir.toString();
        if (this.watchingDirSet.contains(dirStr)) {
            return;
        }
        log.debug("Start to watch dir {}", (Object)dir);
        this.watchingDirSet.add(dir.toString());
        this.registWatcher(dir);
    }

    private void registWatcher(Path dir) {
        try {
            if (this.watcher == null) {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            WatchKey watchKey = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.pathMap.put(watchKey, dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path toParentDir(Path path) {
        if (path.toFile().isFile()) {
            return path.getParent();
        }
        return path;
    }

    @Override
    public Set<String> watching() {
        WatchKey watchKey;
        try {
            watchKey = this.watcher.take();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (ClosedWatchServiceException e) {
            if (this.isContinue()) {
                throw new IllegalStateException(e);
            }
            return Collections.emptySet();
        }
        HashSet<String> inputSources = new HashSet<String>();
        for (WatchEvent<?> event : watchKey.pollEvents()) {
            Path dir = this.pathMap.get(watchKey);
            File changedFile = dir.resolve((Path)event.context()).toFile();
            InputSource inputSource = this.watchingFileMap.get(changedFile.getAbsolutePath());
            if (inputSource == null) {
                inputSource = new InputSource(changedFile.getAbsolutePath(), 0L);
                this.watchingFileMap.put(changedFile.getAbsolutePath(), inputSource);
            }
            if (inputSource.lastModified == changedFile.lastModified()) continue;
            inputSources.add(inputSource.name);
            inputSource.lastModified = changedFile.lastModified();
        }
        watchKey.reset();
        return inputSources;
    }

    @Override
    protected void end(InputSourceEventListener cg) {
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            log.warn("Exception when watcher close", (Throwable)e);
        }
        cg.onChange(this.watchingFileMap.values().stream().map(InputSource::getName).collect(Collectors.toSet()));
    }

    class InputSource {
        String name;
        long lastModified;

        InputSource(String name, long lastModified) {
            this.name = name;
            this.lastModified = lastModified;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getLastModified() {
            return this.lastModified;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputSource)) {
                return false;
            }
            InputSource other = (InputSource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLastModified() == other.getLastModified();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InputSource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $lastModified = this.getLastModified();
            result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
            return result;
        }

        @Generated
        public String toString() {
            return "FileInputSourceWatcher.InputSource(name=" + this.getName() + ", lastModified=" + this.getLastModified() + ")";
        }
    }
}

