/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.cv.core.infra.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitFileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SitFileUtils.class);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private SitFileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void provideTemporaryFile(Path targetDir, Consumer<Path> tempFileConsumer) {
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile(targetDir, ".sit-cv-temp-", null, new FileAttribute[0]);
            log.info("temporary file was created: {}", (Object)tempFile);
            tempFileConsumer.accept(tempFile);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                try {
                    Files.deleteIfExists(tempFile);
                    log.info("temporary file was deleted: {}", (Object)tempFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
        }
        try {
            Files.deleteIfExists(tempFile);
            log.info("temporary file was deleted: {}", (Object)tempFile);
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void createDirectories(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

